/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.xliff.CodeTypeFactory;
import net.sf.okapi.filters.xliff.Parameters;
import net.sf.okapi.filters.xliff.SdlFileInfo;
import net.sf.okapi.filters.xliff.SdlTagDef;
import net.sf.okapi.filters.xliff.XLIFFFilter;

public class XliffSdlFilterExtension {
    public static final String SDL_NAMESPACE_PREFIX = "xmlns:sdl";
    public static final String SDL_NAMESPACE_URI = "http://sdl.com/FileTypes/SdlXliff/1.0";
    public static final QName XLIFF = new QName("", "xliff");
    public static final QName TAG_DEFS = new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "tag-defs");
    public static final QName TAG = new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "tag");
    public static final QName TAG_ID = new QName("", "id");
    public static final QName TAG_BPT = new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "bpt");
    public static final QName TAG_EPT = new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "ept");
    public static final QName TAG_PH = new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "ph");
    public static final QName TAG_IT = new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "it");
    public static final QName TAG_ST = new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "st");
    public static final QName NAME = new QName("", "name");
    public static final QName EQUIV_TEXT = new QName("", "equiv-text");
    private XMLStreamReader reader;
    private XLIFFFilter xliffFilter;
    private Parameters params;
    private int extraId = Integer.MAX_VALUE;
    public static final QName FILE_INFO = new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "file-info");
    public static final QName FILETYPE_ID = new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "filetype-id");
    public static final QName VALUE = new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "value");
    public static final QName KEY = new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "key");
    public static final String SDLWS_AssetId = "SDLWS:AssetId";
    public static final String SDLWS_DocId = "SDLWS:DocId";
    public static final String SDLWS_TaskId = "SDLWS:TaskId";
    public static final String SDLWS_ProjectName = "SDLWS:ProjectName";
    public static final String SDL_FileId = "SDL:FileId";
    public static final String SDL_OriginalFilePath = "SDL:OriginalFilePath";
    public static final String SDLWS_UserName = "SDLWS:UserName";

    public Map<String, SdlTagDef> parse(XMLStreamReader reader, Parameters params, SdlFileInfo sdlFileInfo) throws XMLStreamException {
        this.reader = reader;
        this.xliffFilter = new XLIFFFilter();
        this.params = params;
        return this.parseXLIFF(sdlFileInfo);
    }

    public Map<String, SdlTagDef> parseXLIFF(SdlFileInfo sdlFileInfo) throws XMLStreamException {
        HashMap<String, SdlTagDef> sdlTagdefs = new HashMap<String, SdlTagDef>();
        boolean inTagDefs = false;
        try {
            Serializable name;
            while (this.reader.hasNext()) {
                this.reader.next();
                name = null;
                if (this.reader.isStartElement()) {
                    name = this.reader.getName();
                    if (((QName)name).getLocalPart().equals("xliff")) {
                        NamespaceContext nsc = this.reader.getNamespaceContext();
                        String sdl = nsc.getPrefix(SDL_NAMESPACE_URI);
                        if (sdl != null) continue;
                        Map<String, SdlTagDef> map = null;
                        return map;
                    }
                    if (((QName)name).equals(FILE_INFO)) {
                        this.processFileInfo(sdlFileInfo);
                        continue;
                    }
                    if (((QName)name).equals(FILETYPE_ID)) {
                        sdlFileInfo.sdl_filetype_id = this.getValue();
                        continue;
                    }
                    if (((QName)name).equals(TAG_DEFS)) {
                        inTagDefs = true;
                        continue;
                    }
                    if (inTagDefs && ((QName)name).equals(TAG)) {
                        SdlTagDef t = this.processTag();
                        sdlTagdefs.put(t.id, t);
                        continue;
                    }
                }
                if (!this.reader.isEndElement() || !((QName)(name = this.reader.getName())).equals(TAG_DEFS)) continue;
                HashMap<String, SdlTagDef> hashMap = sdlTagdefs;
                return hashMap;
            }
            name = sdlTagdefs;
            return name;
        }
        catch (XMLStreamException ex) {
            throw new OkapiBadFilterInputException("Failed to parse XLIFF for sdl:fmt-defs\n" + ex.getLocalizedMessage(), ex);
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private void processFileInfo(SdlFileInfo sdlFileInfo) throws XMLStreamException {
        while (this.reader.hasNext()) {
            QName name;
            this.reader.next();
            if (this.reader.isStartElement() && (name = this.reader.getName()).equals(VALUE)) {
                String key;
                switch (key = this.reader.getAttributeValue(null, KEY.getLocalPart())) {
                    case "SDLWS:AssetId": {
                        sdlFileInfo.SDLWS_AssetId = this.getValue();
                        break;
                    }
                    case "SDLWS:DocId": {
                        sdlFileInfo.SDLWS_DocId = this.getValue();
                        break;
                    }
                    case "SDLWS:TaskId": {
                        sdlFileInfo.SDLWS_TaskId = this.getValue();
                        break;
                    }
                    case "SDLWS:ProjectName": {
                        sdlFileInfo.SDLWS_ProjectName = this.getValue();
                        break;
                    }
                    case "SDL:FileId": {
                        sdlFileInfo.SDL_FileId = this.getValue();
                        break;
                    }
                    case "SDL:OriginalFilePath": {
                        sdlFileInfo.SDL_OriginalFilePath = this.getValue();
                        break;
                    }
                    case "SDLWS:UserName": {
                        sdlFileInfo.SDLWS_UserName = this.getValue();
                        break;
                    }
                }
            }
            if (!this.reader.isEndElement() || !(name = this.reader.getName()).equals(FILE_INFO)) continue;
            return;
        }
        throw new OkapiBadFilterInputException("Unexpected EOF processing file-info.");
    }

    private String getValue() throws XMLStreamException {
        StringBuilder value = new StringBuilder();
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 4: 
                case 6: 
                case 12: {
                    value.append(this.reader.getText());
                    break;
                }
                case 2: {
                    return value.toString();
                }
            }
        }
        throw new OkapiBadFilterInputException("Unexpected EOF processing value PCDATA (in file-info).");
    }

    private SdlTagDef processTag() throws XMLStreamException {
        SdlTagDef sdlTagDef = new SdlTagDef();
        sdlTagDef.id = this.reader.getAttributeValue(TAG_ID.getNamespaceURI(), TAG_ID.getLocalPart());
        int numberId = -1;
        try {
            numberId = Util.fastParseInt(sdlTagDef.id);
        }
        catch (NumberFormatException e) {
            numberId = StringUtil.generateIntId(sdlTagDef.id);
        }
        while (this.reader.hasNext()) {
            QName name;
            this.reader.next();
            if (this.reader.isStartElement()) {
                name = this.reader.getName();
                if (name.equals(TAG_BPT)) {
                    sdlTagDef.name = this.reader.getAttributeValue(NAME.getNamespaceURI(), NAME.getLocalPart());
                    sdlTagDef.bpt = this.createCode(TextFragment.TagType.OPENING, numberId, TAG_BPT.getLocalPart(), sdlTagDef.name);
                    sdlTagDef.equiv_text = sdlTagDef.bpt.getDisplayText();
                } else if (name.equals(TAG_EPT)) {
                    sdlTagDef.name = this.reader.getAttributeValue(NAME.getNamespaceURI(), NAME.getLocalPart());
                    sdlTagDef.ept = this.createCode(TextFragment.TagType.CLOSING, numberId, TAG_EPT.getLocalPart(), sdlTagDef.name, sdlTagDef.bpt);
                    sdlTagDef.equiv_text = sdlTagDef.ept.getDisplayText();
                } else if (name.equals(TAG_PH)) {
                    sdlTagDef.name = this.reader.getAttributeValue(NAME.getNamespaceURI(), NAME.getLocalPart());
                    sdlTagDef.ph = this.createCode(TextFragment.TagType.PLACEHOLDER, numberId, TAG_PH.getLocalPart(), sdlTagDef.name);
                    sdlTagDef.equiv_text = sdlTagDef.ph.getDisplayText();
                } else if (name.equals(TAG_IT)) {
                    sdlTagDef.name = this.reader.getAttributeValue(NAME.getNamespaceURI(), NAME.getLocalPart());
                    sdlTagDef.it = this.createCode(TextFragment.TagType.PLACEHOLDER, numberId, TAG_IT.getLocalPart(), sdlTagDef.name);
                    sdlTagDef.equiv_text = sdlTagDef.it.getDisplayText();
                } else if (name.equals(TAG_ST)) {
                    sdlTagDef.name = this.reader.getAttributeValue(NAME.getNamespaceURI(), NAME.getLocalPart());
                    sdlTagDef.st = this.createCode(TextFragment.TagType.PLACEHOLDER, numberId, TAG_ST.getLocalPart(), sdlTagDef.name);
                    sdlTagDef.equiv_text = sdlTagDef.st.getDisplayText();
                }
            }
            if (!this.reader.isEndElement() || !(name = this.reader.getName()).equals(TAG)) continue;
            return sdlTagDef;
        }
        return sdlTagDef;
    }

    private Code createCode(TextFragment.TagType tagType, int id, String tagName, String type) {
        return this.createCode(tagType, id, tagName, type, null);
    }

    private Code createCode(TextFragment.TagType tagType, int id, String tagName, String type, Code openingCode) {
        try {
            String prefix;
            String equiv_text = null;
            TextFragment dummy = new TextFragment();
            int endStack = 1;
            StringBuilder innerCode = new StringBuilder();
            StringBuilder outerCode = null;
            outerCode = new StringBuilder();
            outerCode.append("<" + tagName);
            int count = this.reader.getAttributeCount();
            equiv_text = this.reader.getAttributeValue(EQUIV_TEXT.getNamespaceURI(), EQUIV_TEXT.getLocalPart());
            for (int i = 0; i < count; ++i) {
                if (!this.reader.isAttributeSpecified(i)) continue;
                prefix = this.reader.getAttributePrefix(i);
                outerCode.append(" ");
                if (prefix != null && prefix.length() != 0) {
                    outerCode.append(prefix + ":");
                }
                outerCode.append(this.reader.getAttributeLocalName(i));
                outerCode.append("=\"");
                outerCode.append(Util.escapeToXML(this.reader.getAttributeValue(i), 3, this.params.getEscapeGT(), null));
                outerCode.append("\"");
            }
            outerCode.append(">");
            boolean inSub = false;
            boolean hasSub = false;
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        if (inSub) {
                            throw new OkapiException("Unexpected state in processing sub.");
                        }
                        if (!inSub && this.reader.getLocalName().equals("sub")) {
                            inSub = true;
                        } else if (tagName.equals(this.reader.getLocalName())) {
                            ++endStack;
                        }
                        String tmpg = this.xliffFilter.buildStartCode(this.reader);
                        if (!inSub) {
                            innerCode.append(tmpg.toString());
                        }
                        outerCode.append(tmpg.toString());
                        if (!inSub) break;
                        Code code = dummy.append(tagType, type, innerCode.toString(), id);
                        code.setOuterData(outerCode.toString());
                        List<Object> chunks = this.xliffFilter.processSub(this.reader);
                        for (Object obj : chunks) {
                            if (obj instanceof String) {
                                dummy.append((String)obj);
                                continue;
                            }
                            if (!(obj instanceof Code)) continue;
                            dummy.append((Code)obj);
                        }
                        innerCode.setLength(0);
                        outerCode.append("</sub>");
                        inSub = false;
                        hasSub = true;
                        break;
                    }
                    case 2: {
                        if (inSub) {
                            throw new OkapiException("Unexpected state in processing sub.");
                        }
                        if (tagName.equals(this.reader.getLocalName()) && --endStack == 0) {
                            String codeType = this.createCodeType(innerCode.toString(), type, openingCode);
                            Code code = dummy.append(tagType, codeType, innerCode.toString(), hasSub ? (this.extraId = this.extraId - 1) : id);
                            if (!hasSub && innerCode.length() == 0) {
                                outerCode.insert(outerCode.length() - 1, '/');
                            } else {
                                outerCode.append("</" + tagName + ">");
                            }
                            code.setOuterData(outerCode.toString());
                            code.setData(dummy.toText());
                            code.setDisplayText(equiv_text);
                            return code;
                        }
                        prefix = this.reader.getPrefix();
                        if (prefix == null || prefix.length() == 0) {
                            innerCode.append("</" + this.reader.getLocalName() + ">");
                            outerCode.append("</" + this.reader.getLocalName() + ">");
                            break;
                        }
                        innerCode.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
                        outerCode.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        innerCode.append(this.reader.getText());
                        outerCode.append(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
        return null;
    }

    private String createCodeType(String data, String dataStartElementName, Code openingCode) throws XMLStreamException {
        return null == openingCode ? CodeTypeFactory.createCodeType(data, dataStartElementName) : openingCode.getType();
    }
}

