/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Stack;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.filters.SubFilterSkeletonWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.xliff2.OkpToX2Converter;
import net.sf.okapi.filters.xliff2.Parameters;
import net.sf.okapi.filters.xliff2.SubFilterInfo;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLIFF2FilterWriter
implements IFilterWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Output outputChoice;
    private File outputFile = null;
    private OutputStreamWriter writer;
    private Charset encoding;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private XLIFFWriter xliffToolkitWriter;
    private final OkpToX2Converter converter = new OkpToX2Converter();
    private final EncoderManager encoderManager;
    private final boolean forceUniqueIds;
    private final boolean writeOriginalData;
    private Stack<SubFilterInfo> subFilters;
    private Parameters parameters;

    public XLIFF2FilterWriter(Parameters parameters, EncoderManager encoderManager) {
        this.outputChoice = Output.NONE;
        this.encoding = StandardCharsets.UTF_8;
        this.encoderManager = encoderManager;
        this.parameters = parameters;
        this.forceUniqueIds = parameters.getForceUniqueIds();
        this.writeOriginalData = parameters.getWriteOriginalData();
        this.subFilters = new Stack();
    }

    @Override
    public String getName() {
        return "XLIFF2FilterWriter";
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.targetLocale = locale;
        this.encoding = Charset.forName(defaultEncoding);
    }

    @Override
    public void setOutput(String path) {
        this.close();
        this.outputFile = new File(path);
        this.outputChoice = Output.PATH;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.close();
        this.writer = new OutputStreamWriter(output, this.encoding);
        this.outputChoice = Output.STREAM;
    }

    protected void processStartDocument(StartDocument startDoc) {
        this.initializeWriter(startDoc.getLocale());
        this.converter.startDocument(startDoc).forEach(this.xliffToolkitWriter::writeEvent);
    }

    protected void processEndDocument(Ending ending) {
        this.converter.endDocument(ending).forEach(this.xliffToolkitWriter::writeEvent);
    }

    protected void processStartSubDocument(StartSubDocument startSubDoc) {
        if (!this.subFilters.isEmpty()) {
            this.subFilters.peek().getSubfilter().processStartSubDocument(startSubDoc);
            return;
        }
        this.converter.startSubDocument(startSubDoc).forEach(this.xliffToolkitWriter::writeEvent);
    }

    protected void processEndSubDocument(Ending ending) {
        if (!this.subFilters.isEmpty()) {
            this.subFilters.peek().getSubfilter().processEndSubDocument(ending);
            return;
        }
        this.converter.endSubDocument().forEach(this.xliffToolkitWriter::writeEvent);
    }

    protected void processStartGroup(StartGroup startGroup) {
        if (!this.subFilters.isEmpty()) {
            this.subFilters.peek().getSubfilter().processStartGroup(startGroup);
            return;
        }
        this.converter.startGroup(startGroup).forEach(this.xliffToolkitWriter::writeEvent);
    }

    protected void processEndGroup(Ending endGroup) {
        if (!this.subFilters.isEmpty()) {
            this.subFilters.peek().getSubfilter().processEndGroup(endGroup);
            return;
        }
        this.converter.endGroup(endGroup).forEach(this.xliffToolkitWriter::writeEvent);
    }

    protected void processTextUnit(ITextUnit textUnit) {
        if (!this.subFilters.isEmpty()) {
            this.subFilters.peek().getSubfilter().processTextUnit(textUnit);
            return;
        }
        this.converter.textUnit(textUnit, this.targetLocale).forEach(this.xliffToolkitWriter::writeEvent);
    }

    protected void processDocumentPart(DocumentPart documentPart) {
        if (!this.subFilters.isEmpty()) {
            this.subFilters.peek().getSubfilter().processDocumentPart(documentPart);
            return;
        }
        this.converter.documentPart(documentPart).forEach(this.xliffToolkitWriter::writeEvent);
    }

    protected void processStartSubfilter(StartSubfilter startSubfilter) {
        SubFilterSkeletonWriter subFilterSkeletonWriter = new SubFilterSkeletonWriter(startSubfilter);
        subFilterSkeletonWriter.setOptions(this.targetLocale, this.encoding.name(), startSubfilter);
        this.subFilters.push(new SubFilterInfo(subFilterSkeletonWriter, startSubfilter.getParentTextUnit()));
    }

    protected void processEndSubfilter(EndSubfilter ending) {
        this.subFilters.peek().getSubfilter().processEndDocument(ending);
        String targetText = this.subFilters.peek().getSubfilter().getOutput();
        ITextUnit parentTextUnit = this.subFilters.peek().getParentTextUnit();
        if (this.overWriteTarget(parentTextUnit)) {
            TextContainer targetContainer = new TextContainer(targetText);
            targetContainer.getFirstSegment().setId(parentTextUnit.getSource().getFirstSegment().getId());
            targetContainer.getFirstSegment().setOriginalId(parentTextUnit.getSource().getFirstSegment().getOriginalId());
            parentTextUnit.setTarget(this.targetLocale, targetContainer);
        }
        this.converter.textUnit(parentTextUnit, this.targetLocale).forEach(this.xliffToolkitWriter::writeEvent);
        this.subFilters.peek().getSubfilter().close();
        this.subFilters.pop();
    }

    private boolean overWriteTarget(ITextUnit parentTextUnit) {
        if (this.parameters != null && this.parameters.getSubfilterOverwriteTarget()) {
            return true;
        }
        return !parentTextUnit.getSource().getFirstSegment().hasProperty("state") || !parentTextUnit.getSource().getFirstSegment().getProperty("state").getValue().equals("final");
    }

    @Override
    public Event handleEvent(Event event) {
        if (this.outputChoice == Output.NONE) {
            throw new OkapiMergeException("Output has not been set. Use setOutput().");
        }
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event.getStartDocument());
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument(event.getEnding());
                this.close();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument(event.getStartSubDocument());
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument(event.getEnding());
                break;
            }
            case START_GROUP: {
                this.processStartGroup(event.getStartGroup());
                break;
            }
            case END_GROUP: {
                this.processEndGroup(event.getEndGroup());
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event.getTextUnit());
                break;
            }
            case DOCUMENT_PART: {
                this.processDocumentPart(event.getDocumentPart());
                break;
            }
            case START_SUBFILTER: {
                this.processStartSubfilter(event.getStartSubfilter());
                break;
            }
            case END_SUBFILTER: {
                this.processEndSubfilter(event.getEndSubfilter());
                break;
            }
        }
        return event;
    }

    @Override
    public void close() {
        if (this.xliffToolkitWriter != null) {
            this.xliffToolkitWriter.close();
            this.xliffToolkitWriter = null;
        }
        this.outputFile = null;
        this.outputChoice = Output.NONE;
    }

    @Override
    public IParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(IParameters params) {
        this.parameters = (Parameters)params;
    }

    @Override
    public void cancel() {
        this.close();
    }

    @Override
    public EncoderManager getEncoderManager() {
        return this.encoderManager;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    void initializeWriter(LocaleId sourceLang) {
        this.sourceLocale = sourceLang;
        this.xliffToolkitWriter = new XLIFFWriter();
        String target = this.targetLocale != null ? this.targetLocale.toString() : null;
        switch (this.outputChoice) {
            case PATH: {
                this.xliffToolkitWriter.create(this.outputFile, this.sourceLocale.toString(), target);
                break;
            }
            case STREAM: {
                this.xliffToolkitWriter.create(this.writer, this.sourceLocale.toString(), target);
                break;
            }
            case NONE: {
                this.logger.error("No output set for XLIFF 2 to be written to");
                throw new RuntimeException("No output set for XLIFF 2 to be written to");
            }
        }
        this.xliffToolkitWriter.setWithOriginalData(this.writeOriginalData);
        this.xliffToolkitWriter.setUseIndentation(true);
        this.xliffToolkitWriter.setForceUniqueIds(this.forceUniqueIds);
        this.xliffToolkitWriter.setWithOriginalData(this.writeOriginalData);
    }

    public LocaleId getSourceLocale() {
        return this.sourceLocale;
    }

    public LocaleId getTargetLocale() {
        return this.targetLocale;
    }

    static enum Output {
        NONE,
        PATH,
        STREAM;

    }
}

