/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xmlstream;

import java.net.URL;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.filters.abstractmarkup.AbstractMarkupFilter;
import net.sf.okapi.filters.abstractmarkup.config.TaggedFilterConfiguration;
import net.sf.okapi.filters.xmlstream.Parameters;

@UsingParameters(value=Parameters.class)
public class XmlStreamFilter
extends AbstractMarkupFilter {
    private Parameters parameters;

    public XmlStreamFilter() {
        this.setMimeType("text/xml");
        this.setParameters(new Parameters());
        this.setName("okf_xmlstream");
        this.setDisplayName("XML Stream Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), "text/xml", this.getClass().getName(), "XML Stream", "Large XML Documents", "default.yml"));
        this.addConfiguration(new FilterConfiguration(this.getName() + "-dita", "text/xml", this.getClass().getName(), "DITA", "DITA XML", "dita.yml", ".dita;.ditamap;"));
        this.addConfiguration(new FilterConfiguration(this.getName() + "-JavaPropertiesHTML", "text/xml", this.getClass().getName(), "Java Properties XML + HTML", "Java Properties XML with Embedded HTML", "javaPropertiesXml.yml"));
    }

    @Override
    protected void startFilter() {
        super.startFilter();
        this.getEventBuilder().initializeCodeFinder(this.getConfig().isUseCodeFinder(), this.getConfig().getCodeFinderRules());
    }

    @Override
    protected void setNewlineType(String newlineType) {
        super.setNewlineType("\n");
    }

    @Override
    protected void handleText(CharSequence text) {
        super.handleText(text.toString().replace("\r\n", "\n").replace("\r", "\n"));
    }

    @Override
    protected String normalizeAttributeName(String attrName, String attrValue, Tag tag) {
        String normalizedName = attrName;
        if (attrName.equalsIgnoreCase("xml:lang")) {
            normalizedName = "language";
        }
        return normalizedName;
    }

    @Override
    protected TaggedFilterConfiguration getConfig() {
        return this.parameters.getTaggedConfig();
    }

    @Override
    public void setParameters(IParameters params) {
        this.parameters = (Parameters)params;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParametersFromURL(URL config) {
        this.parameters = new Parameters(config);
    }
}

