/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.merge;

import java.util.Arrays;
import java.util.Optional;
import net.sf.okapi.common.StringParameters;

public class Parameters
extends StringParameters {
    private static final String PRESERVE_WHITESPACE = "preserveWhitespace";
    static final String APPROVEDONLY = "approvedOnly";
    static final String THROW_EXCEPTION_CODE_DIFFERENCES = "throwExceptionForCodeDifferences";
    static final String THROW_EXCEPTION_SEGMENT_ID_DIFFERENCES = "throwExceptionForSegmentIdDifferences";
    static final String ADD_MISSING = "ADDMISSING";
    static final String COPY_SOURCE_IF_NON_TEXTUAL = "copySourceIfNonTextual";
    static final String MERGE_NOTES = "mergeNotes";
    static final String COPY_CODE_METADATA = "copyCodeMetadata";
    static final String SKIP_ORIGINAL_TARGET_CODE_METADATA = "skipOriginalTargetCodeMetadata";

    @Override
    public void reset() {
        super.reset();
        this.setPreserveWhitespace(false);
        this.setApprovedOnly(false);
        this.setThrowCodeException(false);
        this.setThrowSegmentIdException(true);
        this.setAddMissing(false);
        this.setCopySourceIfNonTextual(true);
        this.setNoteMergeStrategy(NoteMergeStrategy.DISCARD);
        this.setCopyCodeMetadata(true);
        this.setSkipOriginalTargetCodeMetadata(false);
    }

    public boolean isPreserveWhitespace() {
        return this.getBoolean(PRESERVE_WHITESPACE);
    }

    public void setPreserveWhitespace(boolean value) {
        this.setBoolean(PRESERVE_WHITESPACE, value);
    }

    public boolean isApprovedOnly() {
        return this.getBoolean(APPROVEDONLY);
    }

    public void setApprovedOnly(boolean approvedOnly) {
        this.setBoolean(APPROVEDONLY, approvedOnly);
    }

    public boolean isThrowCodeException() {
        return this.getBoolean(THROW_EXCEPTION_CODE_DIFFERENCES);
    }

    public void setThrowCodeException(boolean exception) {
        this.setBoolean(THROW_EXCEPTION_CODE_DIFFERENCES, exception);
    }

    public boolean isThrowSegmentIdException() {
        return this.getBoolean(THROW_EXCEPTION_SEGMENT_ID_DIFFERENCES);
    }

    public void setThrowSegmentIdException(boolean exception) {
        this.setBoolean(THROW_EXCEPTION_SEGMENT_ID_DIFFERENCES, exception);
    }

    public boolean isAddMissing() {
        return this.getBoolean(ADD_MISSING);
    }

    public void setAddMissing(boolean addMissing) {
        this.setBoolean(ADD_MISSING, addMissing);
    }

    public boolean isCopySourceIfNonTextual() {
        return this.getBoolean(COPY_SOURCE_IF_NON_TEXTUAL);
    }

    public void setCopySourceIfNonTextual(boolean copySource) {
        this.setBoolean(COPY_SOURCE_IF_NON_TEXTUAL, copySource);
    }

    public void setNoteMergeStrategy(NoteMergeStrategy noteMergeStrategy) {
        this.setInteger(MERGE_NOTES, noteMergeStrategy.value);
    }

    public NoteMergeStrategy getNoteMergeStrategy() {
        return NoteMergeStrategy.byValue(this.getInteger(MERGE_NOTES)).orElse(NoteMergeStrategy.DISCARD);
    }

    public boolean isCopyCodeMetadata() {
        return this.getBoolean(COPY_CODE_METADATA);
    }

    public void setCopyCodeMetadata(boolean copyCodeMetadata) {
        this.setBoolean(COPY_CODE_METADATA, copyCodeMetadata);
    }

    public boolean isSkipOriginalTargetCodeMetadata() {
        return this.getBoolean(SKIP_ORIGINAL_TARGET_CODE_METADATA);
    }

    public void setSkipOriginalTargetCodeMetadata(boolean skipOriginalTargetCodeMetadata) {
        this.setBoolean(SKIP_ORIGINAL_TARGET_CODE_METADATA, skipOriginalTargetCodeMetadata);
    }

    public static enum NoteMergeStrategy {
        DISCARD(0),
        MERGE(1),
        REPLACE(2);

        private final int value;

        private NoteMergeStrategy(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Optional<NoteMergeStrategy> byValue(int value) {
            return Arrays.stream(NoteMergeStrategy.values()).filter(type -> type.value == value).findFirst();
        }
    }
}

