/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.step;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String PRESERVE_WHITESPACE = "preserveWhitespace";
    private static final String COPYCODEMETADATA = "copyCodeMetadata";

    @Override
    public void reset() {
        super.reset();
        this.setPreserveWhitespace(false);
        this.setCopyCodeMetadata(true);
    }

    public boolean isPreserveWhitespace() {
        return this.getBoolean(PRESERVE_WHITESPACE);
    }

    public void setPreserveWhitespace(boolean value) {
        this.setBoolean(PRESERVE_WHITESPACE, value);
    }

    public boolean isCopyCodeMetadata() {
        return this.getBoolean(COPYCODEMETADATA);
    }

    public void setCopyCodeMetadata(boolean copyCodeMetadata) {
        this.setBoolean(COPYCODEMETADATA, copyCodeMetadata);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(PRESERVE_WHITESPACE, "Preserve Whitespace When Reading XLIFF", "Merging preserves the original whitespace in the XLIFF file");
        desc.add(COPYCODEMETADATA, "Copy code metadata from the original file", "Copy code metadata");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription parametersDescription) {
        EditorDescription desc = new EditorDescription("OriginalDocumentXliffMergerStep Parameters", true, false);
        desc.addCheckboxPart(parametersDescription.get(PRESERVE_WHITESPACE));
        desc.addCheckboxPart(parametersDescription.get(COPYCODEMETADATA));
        return desc;
    }
}

