/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.Note;
import net.sf.okapi.common.annotation.NoteAnnotation;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.WhitespaceStrategy;
import net.sf.okapi.proto.AltTranslation;
import net.sf.okapi.proto.Code;
import net.sf.okapi.proto.EndDocument;
import net.sf.okapi.proto.EndGroup;
import net.sf.okapi.proto.EndSubDocument;
import net.sf.okapi.proto.EndSubfilter;
import net.sf.okapi.proto.Event;
import net.sf.okapi.proto.Events;
import net.sf.okapi.proto.INameable;
import net.sf.okapi.proto.IReferenceable;
import net.sf.okapi.proto.IResource;
import net.sf.okapi.proto.Note;
import net.sf.okapi.proto.Property;
import net.sf.okapi.proto.StartDocument;
import net.sf.okapi.proto.StartGroup;
import net.sf.okapi.proto.StartSubDocument;
import net.sf.okapi.proto.StartSubfilter;
import net.sf.okapi.proto.TextContainer;
import net.sf.okapi.proto.TextFragment;
import net.sf.okapi.proto.TextPart;
import net.sf.okapi.proto.TextUnit;

public class Proto2Okapi {
    static TextFragment.TagType toTagType(TextFragment.TagType tt) {
        switch (tt) {
            case CLOSING: {
                return TextFragment.TagType.CLOSING;
            }
            case OPENING: {
                return TextFragment.TagType.OPENING;
            }
            case PLACEHOLDER: {
                return TextFragment.TagType.PLACEHOLDER;
            }
        }
        return TextFragment.TagType.valueOf("ERROR");
    }

    static net.sf.okapi.common.resource.Code toCode(Code code) {
        net.sf.okapi.common.resource.Code result = new net.sf.okapi.common.resource.Code(Proto2Okapi.toTagType(code.getTagType()), code.getCodeType(), code.getData());
        result.setId(code.getId());
        result.setFlag(code.getFlag());
        result.setDisplayText(code.getDisplayText());
        result.setOriginalId(code.getOriginalId());
        result.setAdded(code.getAdded());
        if (code.hasOuterData()) {
            result.setOuterData(code.getOuterData());
        }
        if (code.hasMergedData()) {
            result.setMergedData(code.getMergedData());
        }
        if (code.getInlineAnnotationsCount() > 0) {
            for (Map.Entry entry : code.getInlineAnnotationsMap().entrySet()) {
                if (((String)entry.getKey()).equals("PROPERTIES")) continue;
                GenericAnnotations.addAnnotations(result, new GenericAnnotations((String)entry.getValue()));
            }
        }
        for (Property property : code.getPropertiesList()) {
            result.setProperty(Proto2Okapi.toProperty(property));
        }
        return result;
    }

    static net.sf.okapi.common.resource.TextFragment toTextFragment(TextFragment tf) {
        net.sf.okapi.common.resource.TextFragment result = new net.sf.okapi.common.resource.TextFragment(tf.getText());
        int codeCount = 0;
        for (Code code : tf.getCodesList()) {
            result.insert(code.getPosition() + codeCount * 2, Proto2Okapi.toCode(code));
            ++codeCount;
        }
        result.balanceMarkers();
        return result;
    }

    static TextPart toTextPart(net.sf.okapi.proto.TextPart part) {
        TextPart result = part.getSegment() ? new Segment(part.getResource().getId(), Proto2Okapi.toTextFragment(part.getText())) : new TextPart(Proto2Okapi.toTextFragment(part.getText()));
        Proto2Okapi.setIResource(result, part.getResource());
        result.setOriginalId(part.getOriginalId());
        result.setWhitespaceStrategy(Proto2Okapi.toWhitespaceStrategy(part.getWhitespaceStrategy()));
        if (part.getAltTransCount() > 0) {
            AltTranslationsAnnotation ann = new AltTranslationsAnnotation();
            for (AltTranslation at : part.getAltTransList()) {
                ann.add(Proto2Okapi.toAltTrans(at));
            }
            result.setAnnotation(ann);
        }
        return result;
    }

    static WhitespaceStrategy toWhitespaceStrategy(TextPart.WhitespaceStrategy whitespaceStrategy) {
        switch (whitespaceStrategy.getNumber()) {
            case 0: {
                return WhitespaceStrategy.INHERIT;
            }
            case 1: {
                return WhitespaceStrategy.PRESERVE;
            }
            case 2: {
                return WhitespaceStrategy.NORMALIZE;
            }
        }
        return WhitespaceStrategy.INHERIT;
    }

    static net.sf.okapi.common.resource.Property toProperty(Property prop) {
        EnumSet<Property.Type> types = EnumSet.noneOf(Property.Type.class);
        for (Property.PropertyType type : prop.getTypesList()) {
            types.add(Property.Type.valueOf(type.name()));
        }
        net.sf.okapi.common.resource.Property p = new net.sf.okapi.common.resource.Property(prop.getName(), prop.getValue(), prop.getReadOnly());
        p.setTypes(types);
        return p;
    }

    static net.sf.okapi.common.resource.TextContainer toTextContainer(TextContainer tc) {
        ArrayList<TextPart> parts = new ArrayList<TextPart>();
        for (net.sf.okapi.proto.TextPart textPart : tc.getPartsList()) {
            parts.add(Proto2Okapi.toTextPart(textPart));
        }
        net.sf.okapi.common.resource.TextContainer result = new net.sf.okapi.common.resource.TextContainer(parts.toArray(new TextPart[0]));
        Proto2Okapi.setINameable(result, tc.getNameable());
        result.setHasBeenSegmentedFlag(tc.getSegApplied());
        for (Property property : tc.getNameable().getResource().getPropertiesList()) {
            result.setProperty(Proto2Okapi.toProperty(property));
        }
        if (tc.getAltTransCount() > 0) {
            AltTranslationsAnnotation altTranslationsAnnotation = new AltTranslationsAnnotation();
            for (AltTranslation at : tc.getAltTransList()) {
                altTranslationsAnnotation.add(Proto2Okapi.toAltTrans(at));
            }
            result.setAnnotation(altTranslationsAnnotation);
        }
        NoteAnnotation noteAnnotation = new NoteAnnotation();
        for (Note note : tc.getNotesList()) {
            noteAnnotation.add(Proto2Okapi.toNote(note));
        }
        result.setAnnotation(noteAnnotation);
        return result;
    }

    static net.sf.okapi.common.annotation.Note toNote(Note note) {
        net.sf.okapi.common.annotation.Note result = new net.sf.okapi.common.annotation.Note(note.getNote());
        result.setAnnotates(Proto2Okapi.toAnnotates(note.getAnnotates()));
        result.setPriority(Proto2Okapi.toPriority(note.getPriority()));
        result.setFrom(note.getFrom());
        result.setXmlLang(note.getXmlLang());
        return result;
    }

    static Note.Annotates toAnnotates(Note.Annotates annotates) {
        switch (annotates.name()) {
            case "source": {
                return Note.Annotates.SOURCE;
            }
            case "target": {
                return Note.Annotates.TARGET;
            }
        }
        return Note.Annotates.GENERAL;
    }

    static Note.Priority toPriority(Note.Priority priority) {
        switch (priority.getNumber()) {
            case 0: {
                return Note.Priority.ONE;
            }
            case 1: {
                return Note.Priority.TWO;
            }
            case 2: {
                return Note.Priority.THREE;
            }
            case 3: {
                return Note.Priority.FOUR;
            }
            case 4: {
                return Note.Priority.FIVE;
            }
            case 5: {
                return Note.Priority.SIX;
            }
            case 6: {
                return Note.Priority.SEVEN;
            }
            case 7: {
                return Note.Priority.EIGHT;
            }
            case 8: {
                return Note.Priority.NINE;
            }
        }
        return Note.Priority.TEN;
    }

    static MatchType toMatchType(AltTranslation.MatchType matchType) {
        switch (matchType.toString()) {
            case "ACCEPTED": {
                return MatchType.ACCEPTED;
            }
            case "EXACT_UNIQUE_ID": {
                return MatchType.EXACT_UNIQUE_ID;
            }
            case "EXACT_LOCAL_CONTEXT": {
                return MatchType.EXACT_LOCAL_CONTEXT;
            }
            case "EXACT": {
                return MatchType.EXACT;
            }
            case "EXACT_TEXT_ONLY": {
                return MatchType.EXACT_TEXT_ONLY;
            }
            case "FUZZY": {
                return MatchType.FUZZY;
            }
        }
        return MatchType.UKNOWN;
    }

    static net.sf.okapi.common.annotation.AltTranslation toAltTrans(AltTranslation altTrans) {
        LocaleId srcLoc = LocaleId.fromBCP47(altTrans.getSourceLocale());
        LocaleId trgLoc = LocaleId.fromBCP47(altTrans.getTargetLocale());
        net.sf.okapi.common.annotation.AltTranslation result = new net.sf.okapi.common.annotation.AltTranslation(srcLoc, trgLoc, Proto2Okapi.toTextUnit(altTrans.getTextUnit()), Proto2Okapi.toMatchType(altTrans.getType()), altTrans.getCombinedScore(), altTrans.getOrigin());
        result.setEngine(altTrans.getEngine());
        result.setFromOriginal(altTrans.getFromOriginal());
        result.setFuzzyScore(altTrans.getFuzzyScore());
        result.setQualityScore(altTrans.getQualityScore());
        result.setAltTransType(altTrans.getAltTransType());
        return result;
    }

    static net.sf.okapi.common.resource.TextUnit toTextUnit(TextUnit value) {
        net.sf.okapi.common.resource.TextUnit result = new net.sf.okapi.common.resource.TextUnit("");
        Proto2Okapi.setINameable(result, value.getNameable());
        Proto2Okapi.setIReferenceable(result, value.getReferenceable());
        result.setSource(Proto2Okapi.toTextContainer(value.getSource()));
        for (Map.Entry<String, TextContainer> trg : value.getTargetsMap().entrySet()) {
            result.setTarget(LocaleId.fromBCP47(trg.getKey()), Proto2Okapi.toTextContainer(trg.getValue()));
        }
        NoteAnnotation na = new NoteAnnotation();
        for (Note note : value.getNotesList()) {
            na.add(Proto2Okapi.toNote(note));
        }
        result.setAnnotation(na);
        return result;
    }

    static void setIResource(net.sf.okapi.common.IResource out, IResource value) {
        out.setId(value.getId());
        for (Property property : value.getPropertiesList()) {
            out.setProperty(Proto2Okapi.toProperty(property));
        }
        if (value.hasGenericAnnotations()) {
            GenericAnnotations.addAnnotations(out, GenericAnnotations.createFromString(value.getGenericAnnotations().getEncodedAsString()));
        }
    }

    static void setINameable(net.sf.okapi.common.resource.INameable out, INameable value) {
        Proto2Okapi.setIResource(out, value.getResource());
        out.setName(value.getName());
        out.setType(value.getType());
        out.setMimeType(value.getMimeType());
        out.setIsTranslatable(value.getIsTranslatable());
        out.setPreserveWhitespaces(value.getPreserveWhitespaces());
        for (Property property : value.getResource().getPropertiesList()) {
            out.setProperty(Proto2Okapi.toProperty(property));
        }
    }

    static void setIReferenceable(net.sf.okapi.common.resource.IReferenceable out, IReferenceable value) {
        out.setReferenceCount(value.getRefCount());
    }

    static net.sf.okapi.common.resource.StartDocument toStartDocument(StartDocument value) {
        net.sf.okapi.common.resource.StartDocument result = new net.sf.okapi.common.resource.StartDocument("");
        Proto2Okapi.setINameable(result, value.getNameable());
        result.setLineBreak(value.getLineBreak());
        result.setLocale(LocaleId.fromBCP47(value.getLocale()));
        result.setEncoding(value.getEncoding(), value.getHasUtf8Bom());
        result.setMultilingual(value.getMultilingual());
        if (result.getName().isEmpty()) {
            result.setName("unknown");
        }
        return result;
    }

    static net.sf.okapi.common.resource.StartGroup toStartGroup(StartGroup value) {
        net.sf.okapi.common.resource.StartGroup result = new net.sf.okapi.common.resource.StartGroup();
        result.setParentId(value.getParentId());
        Proto2Okapi.setINameable(result, value.getNameable());
        Proto2Okapi.setIReferenceable(result, value.getReferenceable());
        return result;
    }

    static net.sf.okapi.common.resource.StartSubfilter toStartSubfilter(StartSubfilter value) {
        net.sf.okapi.common.resource.StartSubfilter result = new net.sf.okapi.common.resource.StartSubfilter("", Proto2Okapi.toStartDocument(value.getStartDoc()), null);
        Proto2Okapi.setINameable(result, value.getNameable());
        return result;
    }

    static net.sf.okapi.common.resource.EndSubfilter toEndSubfilter(EndSubfilter value) {
        net.sf.okapi.common.resource.EndSubfilter result = new net.sf.okapi.common.resource.EndSubfilter();
        Proto2Okapi.setIResource(result, value.getResource());
        return result;
    }

    static Ending toEndDocument(EndDocument value) {
        Ending result = new Ending();
        Proto2Okapi.setIResource(result, value.getResource());
        return result;
    }

    static Ending toEndGroup(EndGroup value) {
        Ending result = new Ending();
        Proto2Okapi.setIResource(result, value.getResource());
        return result;
    }

    static Ending toEndSubDocument(EndSubDocument value) {
        Ending result = new Ending();
        Proto2Okapi.setIResource(result, value.getResource());
        return result;
    }

    static net.sf.okapi.common.resource.StartSubDocument toStartSubDocument(StartSubDocument value) {
        net.sf.okapi.common.resource.StartSubDocument result = new net.sf.okapi.common.resource.StartSubDocument();
        result.setParentId(value.getParentId());
        Proto2Okapi.setINameable(result, value.getNameable());
        return result;
    }

    public static net.sf.okapi.common.Event toEvent(Event event) {
        net.sf.okapi.common.Event result = net.sf.okapi.common.Event.createNoopEvent();
        switch (event.getResourceCase()) {
            case ENDDOCUMENT: {
                Ending endDocument = Proto2Okapi.toEndDocument(event.getEndDocument());
                result.setResource(endDocument);
                result.setEventType(EventType.END_DOCUMENT);
                break;
            }
            case STARTDOCUMENT: {
                net.sf.okapi.common.resource.StartDocument doc = Proto2Okapi.toStartDocument(event.getStartDocument());
                result.setResource(doc);
                result.setEventType(EventType.START_DOCUMENT);
                break;
            }
            case TEXTUNIT: {
                net.sf.okapi.common.resource.TextUnit tu = Proto2Okapi.toTextUnit(event.getTextUnit());
                result.setResource(tu);
                result.setEventType(EventType.TEXT_UNIT);
                break;
            }
            case STARTGROUP: {
                net.sf.okapi.common.resource.StartGroup startGroup = Proto2Okapi.toStartGroup(event.getStartGroup());
                result.setResource(startGroup);
                result.setEventType(EventType.START_GROUP);
                break;
            }
            case ENDGROUP: {
                Ending endGroup = Proto2Okapi.toEndGroup(event.getEndGroup());
                result.setResource(endGroup);
                result.setEventType(EventType.END_GROUP);
                break;
            }
            case STARTSUBFILTER: {
                net.sf.okapi.common.resource.StartSubfilter startSubfilter = Proto2Okapi.toStartSubfilter(event.getStartSubfilter());
                result.setResource(startSubfilter);
                result.setEventType(EventType.START_SUBFILTER);
                break;
            }
            case ENDSUBFILTER: {
                net.sf.okapi.common.resource.EndSubfilter endSubfilter = Proto2Okapi.toEndSubfilter(event.getEndSubfilter());
                result.setResource(endSubfilter);
                result.setEventType(EventType.END_SUBFILTER);
                break;
            }
            case STARTSUBDOCUMENT: {
                net.sf.okapi.common.resource.StartSubDocument startSubDocument = Proto2Okapi.toStartSubDocument(event.getStartSubDocument());
                result.setResource(startSubDocument);
                result.setEventType(EventType.START_SUBDOCUMENT);
                break;
            }
            case ENDSUBDOCUMENT: {
                Ending endSubDocument = Proto2Okapi.toEndSubDocument(event.getEndSubDocument());
                result.setResource(endSubDocument);
                result.setEventType(EventType.END_SUBDOCUMENT);
                break;
            }
        }
        return result;
    }

    public static List<net.sf.okapi.common.Event> toEvents(Events value) {
        ArrayList<net.sf.okapi.common.Event> events = new ArrayList<net.sf.okapi.common.Event>();
        for (Event event : value.getEventsList()) {
            events.add(Proto2Okapi.toEvent(event));
        }
        return events;
    }
}

