/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization.writer;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.lib.serialization.Okapi2Proto;
import net.sf.okapi.lib.serialization.filter.Parameters;
import net.sf.okapi.proto.Event;

public class ProtoBufferWriter
implements IFilterWriter {
    private OutputStream outputStream;
    private String outputPath;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private boolean canceled;
    private Parameters params = new Parameters();
    private OutputStreamWriter outputWriter;

    public ProtoBufferWriter() {
        this.params.setOutput(Parameters.PROTOBUF_OUTPUT.JSON_LINES);
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void setOptions(LocaleId targetLocale, String defaultEncoding) {
        this.targetLocale = targetLocale;
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputPath = null;
        this.outputStream = output;
    }

    @Override
    public net.sf.okapi.common.Event handleEvent(net.sf.okapi.common.Event event) {
        if (this.canceled) {
            return new net.sf.okapi.common.Event(EventType.CANCELED);
        }
        try {
            switch (event.getEventType()) {
                case START_DOCUMENT: {
                    this.processStartDocument(event);
                    break;
                }
                case TEXT_UNIT: {
                    this.processTextUnit(event);
                    break;
                }
                case START_GROUP: 
                case START_SUBFILTER: 
                case START_SUBDOCUMENT: 
                case END_GROUP: 
                case END_SUBFILTER: 
                case END_SUBDOCUMENT: 
                case END_DOCUMENT: {
                    break;
                }
                default: {
                    event = net.sf.okapi.common.Event.createNoopEvent();
                }
            }
            this.saveEvent(event);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return event;
    }

    private void processTextUnit(net.sf.okapi.common.Event event) throws IOException {
        if (this.params.isCopySource() && (!event.getTextUnit().hasTarget(this.targetLocale) || event.getTextUnit().getTarget(this.targetLocale).isEmpty())) {
            TextContainer tc = event.getTextUnit().getSource().clone();
            event.getTextUnit().setTarget(this.targetLocale, tc);
        }
    }

    private void saveEvent(net.sf.okapi.common.Event event) throws IOException {
        switch (this.params.getOutput()) {
            case BINARY: {
                this.saveToBinaryFile(Okapi2Proto.toEvent(event, this.sourceLocale));
                break;
            }
            case JSON_LINES: {
                this.saveToJsonFile(Okapi2Proto.toEvent(event, this.sourceLocale));
            }
        }
    }

    private void saveToJsonFile(Event proto) throws IOException {
        this.outputWriter.write(JsonFormat.printer().includingDefaultValueFields().omittingInsignificantWhitespace().print((MessageOrBuilder)proto));
        this.outputWriter.write("\n");
    }

    private void saveToBinaryFile(Event proto) throws IOException {
        proto.writeDelimitedTo(this.outputStream);
    }

    private void processStartDocument(net.sf.okapi.common.Event event) throws IOException {
        if (this.outputStream == null) {
            try {
                this.outputStream = new FileOutputStream(this.outputPath);
            }
            catch (FileNotFoundException e) {
                throw new OkapiIOException("Error serializing TextUnit", e);
            }
        }
        if (this.params.getOutput() != Parameters.PROTOBUF_OUTPUT.BINARY) {
            this.outputWriter = new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8);
        }
        this.sourceLocale = event.getStartDocument().getLocale();
    }

    @Override
    public void close() {
        if (this.outputWriter != null) {
            try {
                this.outputWriter.close();
                this.outputWriter = null;
            }
            catch (IOException e) {
                throw new OkapiIOException("Error closing JSON writer", e);
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
                this.outputStream = null;
            }
            catch (IOException e) {
                throw new OkapiIOException("Error closing protobuf stream", e);
            }
        }
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void cancel() {
        this.close();
        this.canceled = true;
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }
}

