/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.terminology.simpletb;

import java.io.File;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.terminology.ITermAccess;
import net.sf.okapi.lib.terminology.TermHit;
import net.sf.okapi.lib.terminology.simpletb.Entry;
import net.sf.okapi.lib.terminology.simpletb.Parameters;
import net.sf.okapi.lib.terminology.simpletb.SimpleTB;

public class SimpleTBConnector
implements ITermAccess {
    private Parameters params = new Parameters();
    private SimpleTB tb;

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void open() {
        this.tb = new SimpleTB(this.params.getSourceLocale(), this.params.getTargetLocale());
        if (!Util.isEmpty(this.params.getGlossaryPath())) {
            this.tb.importTBX(new File(this.params.getGlossaryPath()));
        }
    }

    @Override
    public void close() {
        this.tb.removeAll();
    }

    @Override
    public List<TermHit> getExistingTerms(TextFragment fragment, LocaleId fragmentLocId, LocaleId otherLocId) {
        return this.tb.getExistingTerms(fragment, fragmentLocId, otherLocId);
    }

    @Override
    public List<TermHit> getExistingStrings(TextFragment fragment, LocaleId fragmentLocId, LocaleId otherLocId) {
        return this.tb.getExistingStrings(fragment, fragmentLocId, otherLocId);
    }

    public void initializeSearch(boolean stringSearch, boolean betweenCodes) {
        this.tb.initialize(stringSearch, betweenCodes);
    }

    public Entry addEntry(String srcTerm, String trgTerm) {
        return this.tb.addEntry(srcTerm, trgTerm);
    }
}

