/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.HTMLCharacterEntities;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryUtil {
    private static final Pattern TAG = Pattern.compile("(<(br|u)(\\s+)id=['\"](.*?)['\"](\\s*?)/?>)|(</u>)", 2);
    private static final Pattern HTML_SPAN = Pattern.compile("\\<span\\s*?(.*?)>|\\</span>", 34);
    private static final Pattern CR = Pattern.compile("&(?:#(\\S+?)|\\w*?);");
    private final StringBuilder codesMarkers = new StringBuilder();
    private final XLIFFContent fmt = new XLIFFContent();
    private List<Code> codes;
    private HTMLCharacterEntities entities;

    public boolean hasCode() {
        if (this.codes == null) {
            return false;
        }
        return !this.codes.isEmpty();
    }

    public String separateCodesFromText(TextFragment frag) {
        this.codesMarkers.setLength(0);
        this.codes = frag.getCodes();
        String text = frag.getCodedText();
        if (!frag.hasCode()) {
            return text;
        }
        StringBuilder tmp = new StringBuilder(text.length() - this.codes.size() * 2);
        block3: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    this.codesMarkers.append(text.charAt(i));
                    this.codesMarkers.append(text.charAt(++i));
                    continue block3;
                }
                default: {
                    tmp.append(text.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public TextFragment createNewFragmentWithCodes(String plainText) {
        return new TextFragment(plainText + String.valueOf(this.codesMarkers), this.codes);
    }

    public List<String> toCodedHTML(List<TextFragment> frags) {
        ArrayList<String> html = new ArrayList<String>(frags.size());
        for (TextFragment frag : frags) {
            html.add(this.toCodedHTML(frag));
        }
        return html;
    }

    public String toCodedHTML(TextFragment fragment) {
        if (fragment == null) {
            return "";
        }
        String text = fragment.getCodedText();
        StringBuilder sb = new StringBuilder();
        block12: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': {
                    Code code = fragment.getCode(text.charAt(++i));
                    sb.append("<u id='");
                    sb.append(code.getId());
                    sb.append("'>");
                    continue block12;
                }
                case '\ue102': {
                    ++i;
                    sb.append("</u>");
                    continue block12;
                }
                case '\ue103': {
                    Code code = fragment.getCode(text.charAt(++i));
                    switch (code.getTagType()) {
                        case OPENING: {
                            sb.append("<br id='b");
                            sb.append(code.getId());
                            sb.append("'/>");
                            break;
                        }
                        case CLOSING: {
                            sb.append("<br id='e");
                            sb.append(code.getId());
                            sb.append("'/>");
                            break;
                        }
                        case PLACEHOLDER: {
                            sb.append("<br id='p");
                            sb.append(code.getId());
                            sb.append("'/>");
                        }
                    }
                    continue block12;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block12;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block12;
                }
                default: {
                    sb.append(text.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    public TextFragment fromCodedHTMLToFragment(String text, TextFragment fragment) {
        if (Util.isEmpty(text)) {
            if (fragment != null) {
                fragment.setCodedText("", true);
                return fragment;
            }
            return new TextFragment();
        }
        text = this.unescapeCharacterReferences(text);
        ArrayList<Code> codes = new ArrayList<Code>();
        text = this.translateCodedHTMLToFragment(text, codes);
        StringBuilder sb = new StringBuilder(text);
        QueryUtil.removeSpans(sb);
        if (fragment != null) {
            fragment.setCodedText(sb.toString(), codes, true);
            return fragment;
        }
        return new TextFragment(sb.toString(), codes);
    }

    private String unescapeCharacterReferences(String text) {
        this.initHTMLCharacterEntities();
        Matcher crMatch = CR.matcher(text);
        StringBuilder result = new StringBuilder(text.length());
        int textIndex = 0;
        while (crMatch.find()) {
            int character;
            if (crMatch.start() > 0) {
                result.append(text, textIndex, crMatch.start());
            }
            textIndex = crMatch.end();
            String numeric = crMatch.group(1);
            if (numeric != null) {
                try {
                    character = numeric.charAt(0) == 'x' ? Integer.parseInt(numeric.substring(1), 16) : Integer.parseInt(numeric);
                }
                catch (NumberFormatException e) {
                    character = 63;
                }
                result.append((char)character);
                continue;
            }
            character = this.entities.lookupReference(crMatch.group(0));
            if (character == -1) continue;
            result.append((char)character);
        }
        result.append(text.substring(textIndex));
        return result.toString();
    }

    private String translateCodedHTMLToFragment(String text, ArrayList<Code> codes) {
        Matcher tagMatches = TAG.matcher(text);
        StringBuilder result = new StringBuilder(text.length());
        int textIndex = 0;
        while (tagMatches.find()) {
            int codeId;
            Code code;
            if (tagMatches.start() > 0) {
                result.append(text, textIndex, tagMatches.start());
            }
            textIndex = tagMatches.end();
            if (tagMatches.group(1) == null) {
                code = new Code(TextFragment.TagType.CLOSING, "Xpt", null);
                codes.add(code);
                result.append('\ue102');
                result.append(TextFragment.toChar(codes.size() - 1));
                continue;
            }
            if ("u".equals(tagMatches.group(2))) {
                codeId = Util.strToInt(tagMatches.group(4), -1);
                code = new Code(TextFragment.TagType.OPENING, "Xpt", null);
                code.setId(codeId);
                codes.add(code);
                result.append('\ue101');
                result.append(TextFragment.toChar(codes.size() - 1));
                continue;
            }
            codeId = Util.strToInt(tagMatches.group(4).substring(1), -1);
            code = new Code(switch (tagMatches.group(4).charAt(0)) {
                case 'b' -> TextFragment.TagType.OPENING;
                case 'e' -> TextFragment.TagType.CLOSING;
                case 'p' -> TextFragment.TagType.PLACEHOLDER;
                default -> throw new OkapiException("ID of isolated code modified.");
            }, "Xph", null);
            code.setId(codeId);
            codes.add(code);
            result.append('\ue103');
            result.append(TextFragment.toChar(codes.size() - 1));
        }
        result.append(text.substring(textIndex));
        return result.toString();
    }

    public String fromCodedHTML(String htmlText, TextFragment fragment, boolean addMissingCodes) {
        return this.fromCodedHTML(htmlText, fragment, addMissingCodes, true);
    }

    public String fromCodedHTML(String htmlText, TextFragment fragment, boolean addMissingCodes, boolean removeSpans) {
        if (Util.isEmpty(htmlText)) {
            return "";
        }
        htmlText = this.unescapeCharacterReferences(htmlText);
        ArrayList<String> newCodes = new ArrayList<String>(fragment.getCodes().size());
        String codedText = QueryUtil.translateCodedHTML(fragment, htmlText, newCodes);
        StringBuilder sb = new StringBuilder(codedText);
        if (removeSpans) {
            QueryUtil.removeSpans(sb);
        }
        if (addMissingCodes) {
            ArrayList<String> oriCodes = QueryUtil.getCodeIdAttrValues(fragment);
            if (newCodes.size() < oriCodes.size()) {
                for (String tmp : oriCodes) {
                    if (newCodes.contains(tmp)) continue;
                    switch (tmp.charAt(0)) {
                        case 'o': {
                            sb.append('\ue101');
                            sb.append(TextFragment.toChar(fragment.getIndex(Integer.parseInt(tmp.substring(1)))));
                            break;
                        }
                        case 'c': {
                            sb.append('\ue102');
                            sb.append(TextFragment.toChar(fragment.getIndexForClosing(Integer.parseInt(tmp.substring(1)))));
                            break;
                        }
                        case 'b': 
                        case 'e': 
                        case 'p': {
                            sb.append('\ue103');
                            sb.append(TextFragment.toChar(fragment.getIndex(Integer.parseInt(tmp.substring(1)))));
                        }
                    }
                }
            }
        }
        return sb.toString();
    }

    private static void removeSpans(StringBuilder sb) {
        Matcher m = HTML_SPAN.matcher(sb.toString());
        int offset = 0;
        while (m.find()) {
            sb.delete(m.start() - offset, m.end() - offset);
            offset += m.end() - m.start();
        }
    }

    private void initHTMLCharacterEntities() {
        if (this.entities == null) {
            this.entities = new HTMLCharacterEntities();
            this.entities.ensureInitialization(true);
        }
    }

    private static String translateCodedHTML(TextFragment fragment, String text, ArrayList<String> newCodes) {
        Stack<Integer> stack = new Stack<Integer>();
        Matcher tagMatches = TAG.matcher(text);
        StringBuilder result = new StringBuilder(text.length());
        int textIndex = 0;
        block4: while (tagMatches.find()) {
            int codeId;
            if (tagMatches.start() > 0) {
                result.append(text, textIndex, tagMatches.start());
            }
            textIndex = tagMatches.end();
            if (tagMatches.group(1) == null) {
                if (stack.isEmpty()) continue;
                codeId = (Integer)stack.pop();
                newCodes.add("c" + codeId);
                result.append('\ue102');
                result.append(TextFragment.toChar(fragment.getIndexForClosing(codeId)));
                continue;
            }
            if ("u".equals(tagMatches.group(2))) {
                codeId = Util.strToInt(tagMatches.group(4), -1);
                stack.push(codeId);
                newCodes.add("o" + codeId);
                result.append('\ue101');
                result.append(TextFragment.toChar(fragment.getIndex(codeId)));
                continue;
            }
            char isoType = tagMatches.group(4).charAt(0);
            codeId = Util.strToInt(tagMatches.group(4).substring(1), -1);
            newCodes.add(isoType + Integer.toString(codeId));
            result.append('\ue103');
            switch (isoType) {
                case 'b': {
                    result.append(TextFragment.toChar(fragment.getIndexForOpening(codeId)));
                    continue block4;
                }
                case 'e': {
                    result.append(TextFragment.toChar(fragment.getIndexForClosing(codeId)));
                    continue block4;
                }
            }
            result.append(TextFragment.toChar(fragment.getIndex(codeId)));
        }
        result.append(text.substring(textIndex));
        return result.toString();
    }

    private static ArrayList<String> getCodeIdAttrValues(TextFragment fragment) {
        ArrayList<String> oriCodes = new ArrayList<String>(fragment.getCodes().size());
        for (Code code : fragment.getCodes()) {
            block0 : switch (code.getTagType()) {
                case OPENING: {
                    oriCodes.add("o" + code.getId());
                    break;
                }
                case CLOSING: {
                    oriCodes.add("c" + code.getId());
                    break;
                }
                case PLACEHOLDER: {
                    switch (code.getTagType()) {
                        case OPENING: {
                            oriCodes.add("b" + code.getId());
                            break block0;
                        }
                        case CLOSING: {
                            oriCodes.add("e" + code.getId());
                            break block0;
                        }
                        case PLACEHOLDER: {
                            oriCodes.add("p" + code.getId());
                        }
                    }
                }
            }
        }
        return oriCodes;
    }

    public String toXLIFF(TextFragment fragment) {
        if (fragment == null) {
            return "";
        }
        this.fmt.setContent(fragment);
        return this.fmt.toString();
    }

    public TextFragment fromXLIFF(Element elem, TextFragment original) {
        NodeList list = elem.getChildNodes();
        int lastId = -1;
        int id = -1;
        Stack<Integer> stack = new Stack<Integer>();
        StringBuilder buffer = new StringBuilder();
        block16: for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            block0 : switch (node.getNodeType()) {
                case 3: {
                    buffer.append(node.getNodeValue());
                    continue block16;
                }
                case 1: {
                    NamedNodeMap map = node.getAttributes();
                    switch (node.getNodeName()) {
                        case "bpt": {
                            id = this.getRawIndex(lastId, map.getNamedItem("id"));
                            stack.push(id);
                            buffer.append(new String(new char[]{'\ue101', TextFragment.toChar(original.getIndex(id))}));
                            break block0;
                        }
                        case "ept": {
                            buffer.append(new String(new char[]{'\ue102', TextFragment.toChar(original.getIndexForClosing((Integer)stack.pop()))}));
                            break block0;
                        }
                        case "ph": {
                            id = this.getRawIndex(lastId, map.getNamedItem("id"));
                            buffer.append(new String(new char[]{'\ue103', TextFragment.toChar(original.getIndex(id))}));
                            break block0;
                        }
                        case "it": {
                            Node pos = map.getNamedItem("pos");
                            if (pos == null) {
                                id = this.getRawIndex(lastId, map.getNamedItem("id"));
                                buffer.append(new String(new char[]{'\ue103', TextFragment.toChar(original.getIndex(id))}));
                                break block0;
                            }
                            if (pos.getNodeValue().equals("begin")) {
                                id = this.getRawIndex(lastId, map.getNamedItem("id"));
                                buffer.append(new String(new char[]{'\ue101', TextFragment.toChar(original.getIndex(id))}));
                                break block0;
                            }
                            id = this.getRawIndex(lastId, map.getNamedItem("id"));
                            buffer.append(new String(new char[]{'\ue102', TextFragment.toChar(original.getIndexForClosing(id))}));
                        }
                    }
                }
            }
        }
        return new TextFragment(buffer.toString(), original.getCodes());
    }

    public static ArrayList<QueryResult> removeDuplicates(List<QueryResult> queryResults) {
        LinkedHashSet<QueryResult> dupRemove = new LinkedHashSet<QueryResult>(queryResults.size());
        Collections.sort(queryResults);
        dupRemove.addAll(queryResults);
        return new ArrayList<QueryResult>(dupRemove);
    }

    private int getRawIndex(int lastIndex, Node attr) {
        if (attr == null) {
            return ++lastIndex;
        }
        return Integer.parseInt(attr.getNodeValue());
    }
}

