/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.QualityChecker;
import net.sf.okapi.lib.verification.ValidateXliffSchema;

public class QualityCheckSession {
    public static final String FILE_EXTENSION = ".qcs";
    private static final String SERIALSIGNATURE = "OQCS";
    private static final long SERIALVERSIONUID = 2L;
    private static final long SERIALVERSIONUID_1BLOCK = 1L;
    private static final int MAXBLOCKLEN = 21666;
    Map<URI, RawDocument> rawDocs;
    IFilterConfigurationMapper fcMapper;
    private Parameters params;
    private List<Issue> issues;
    private QualityChecker checker;
    private LocaleId sourceLocale = LocaleId.ENGLISH;
    private LocaleId targetLocale = LocaleId.FRENCH;
    private IFilter filter;
    private boolean modified;
    private boolean autoRefresh;

    public QualityCheckSession() {
        this.reset();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public Parameters getParameters() {
        return this.params;
    }

    public void setParameters(Parameters params) {
        this.params = params;
    }

    public boolean getAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public void addRawDocument(RawDocument rawDoc) {
        URI uri = rawDoc.getInputURI();
        this.rawDocs.put(uri, rawDoc);
        if (this.rawDocs.size() == 1) {
            this.sourceLocale = rawDoc.getSourceLocale();
            this.targetLocale = rawDoc.getTargetLocale();
        }
        this.modified = true;
    }

    public List<RawDocument> getDocuments() {
        return new ArrayList<RawDocument>(this.rawDocs.values());
    }

    public Map<URI, RawDocument> getDocumentsMap() {
        return this.rawDocs;
    }

    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    public IFilterConfigurationMapper getFilterConfigurationMapper() {
        return this.fcMapper;
    }

    public LocaleId getSourceLocale() {
        return this.sourceLocale;
    }

    public void setSourceLocale(LocaleId sourceLocale) {
        if (!this.sourceLocale.equals(sourceLocale)) {
            this.modified = true;
        }
        this.sourceLocale = sourceLocale;
    }

    public LocaleId getTargetLocale() {
        return this.targetLocale;
    }

    public void setTargetLocale(LocaleId targetLocale) {
        if (!this.targetLocale.equals(targetLocale)) {
            this.modified = true;
        }
        this.targetLocale = targetLocale;
    }

    public void reset() {
        this.rawDocs = new HashMap<URI, RawDocument>();
        this.issues = new ArrayList<Issue>();
        this.params = new Parameters();
        this.checker = new QualityChecker();
    }

    public void resetDisabledIssues() {
        for (Issue issue : this.issues) {
            issue.setEnabled(true);
        }
        this.modified = true;
    }

    public int getDocumentCount() {
        return this.rawDocs.size();
    }

    public void recheckDocument(URI docId) {
        this.startProcess(this.sourceLocale, this.targetLocale);
        RawDocument rd = this.rawDocs.get(docId);
        if (rd != null) {
            this.executeRecheck(rd, null);
        }
    }

    public void recheckAll(List<String> sigList) {
        if (this.rawDocs.isEmpty()) {
            this.issues.clear();
            return;
        }
        this.startProcess(this.sourceLocale, this.targetLocale);
        for (RawDocument rd : this.rawDocs.values()) {
            this.executeRecheck(rd, sigList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRecheck(RawDocument rd, List<String> sigList) {
        try {
            this.filter = this.fcMapper.createFilter(rd.getFilterConfigId(), this.filter);
            if (this.filter == null) {
                throw new OkapiException("Unsupported filter type.");
            }
            if ("okf_xliff".equals(this.filter.getName()) && this.params.getCheckXliffSchema()) {
                switch (this.params.getXliffSchemaType()) {
                    case "Transitional": {
                        ValidateXliffSchema.validateXliffSchema(rd.getInputURI(), "xliff-core-1.2-transitional.xsd");
                        break;
                    }
                    case "Strict": {
                        ValidateXliffSchema.validateXliffSchema(rd.getInputURI(), "xliff-core-1.2-strict.xsd");
                    }
                }
            }
            this.filter.open(rd);
            while (this.filter.hasNext()) {
                Event event = this.filter.next();
                switch (event.getEventType()) {
                    case START_DOCUMENT: {
                        StartDocument sd = event.getStartDocument();
                        if (sigList == null) {
                            sigList = this.clearIssues(rd.getInputURI(), true);
                        } else {
                            this.clearIssues(rd.getInputURI(), false);
                        }
                        this.processStartDocument(sd, sigList);
                        break;
                    }
                    case START_SUBDOCUMENT: {
                        this.processStartSubDocument(event.getStartSubDocument());
                        break;
                    }
                    case TEXT_UNIT: {
                        this.processTextUnit(event.getTextUnit());
                        break;
                    }
                }
            }
        }
        finally {
            if (this.filter != null) {
                this.filter.close();
            }
        }
    }

    private List<String> getAllSignatures() {
        ArrayList<String> list = new ArrayList<String>();
        for (Issue issue : this.issues) {
            if (issue.getEnabled()) continue;
            list.add(issue.getSignature());
        }
        return list;
    }

    public List<String> clearIssues(URI docId, boolean generateSigList) {
        ArrayList<String> sigList = null;
        if (generateSigList) {
            sigList = new ArrayList<String>();
        }
        Iterator<Issue> iter = this.issues.iterator();
        while (iter.hasNext()) {
            Issue issue = iter.next();
            if (!issue.getDocumentURI().equals(docId)) continue;
            if (generateSigList && !issue.getEnabled()) {
                sigList.add(issue.getSignature());
            }
            iter.remove();
        }
        return sigList;
    }

    public void saveSession(String path) {
        try {
            this.saveSessionToStream(new FileOutputStream(path));
        }
        catch (IOException e) {
            throw new OkapiIOException("Error while saving session.", e);
        }
    }

    private void saveSessionToStream(OutputStream outputStream) {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(outputStream);
            dos.writeBytes(SERIALSIGNATURE);
            long version = this.getLongStringBlockCount(this.params.toString()) > 1 ? 2L : 1L;
            dos.writeLong(version);
            dos.writeUTF(this.sourceLocale.toString());
            dos.writeUTF(this.targetLocale.toString());
            if (version == 1L) {
                dos.writeUTF(this.params.toString());
            } else {
                this.writeLongString(dos, this.params.toString());
            }
            dos.writeInt(this.rawDocs.size());
            for (RawDocument rd : this.rawDocs.values()) {
                dos.writeUTF(rd.getInputURI().toString());
                dos.writeUTF(rd.getFilterConfigId());
                dos.writeUTF(rd.getEncoding());
            }
            List<String> list = this.getAllSignatures();
            dos.writeInt(list.size());
            for (String sig : list) {
                dos.writeUTF(sig);
            }
            this.modified = false;
        }
        catch (IOException e) {
            throw new OkapiIOException("Error while saving session.", e);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing session file.", e);
                }
            }
        }
    }

    public void loadSession(String path) {
        try {
            this.loadSessionFromStream(new FileInputStream(path));
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error reading session file.\n" + e.getMessage(), e);
        }
    }

    private void loadSessionFromStream(InputStream inputStream) {
        this.reset();
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(inputStream);
            byte[] buf = new byte[4];
            dis.read(buf, 0, 4);
            String tmp = new String(buf);
            if (!tmp.equals(SERIALSIGNATURE)) {
                throw new OkapiIOException("Invalid signature: This file is not a QCS file, or is corrupted.");
            }
            long version = dis.readLong();
            if (version > 2L) {
                throw new OkapiIOException("Invalid version number: This file is not a QCS file, or is corrupted.");
            }
            tmp = dis.readUTF();
            this.sourceLocale = LocaleId.fromString(tmp);
            tmp = dis.readUTF();
            this.targetLocale = LocaleId.fromString(tmp);
            tmp = version == 1L ? dis.readUTF() : this.readLongString(dis);
            this.params.fromString(tmp);
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                tmp = dis.readUTF();
                URI uri = new URI(tmp);
                String configId = dis.readUTF();
                String encoding = dis.readUTF();
                RawDocument rd = new RawDocument(uri, encoding, this.sourceLocale, this.targetLocale);
                rd.setFilterConfigId(configId);
                this.rawDocs.put(uri, rd);
            }
            ArrayList<String> sigList = new ArrayList<String>();
            count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                sigList.add(dis.readUTF());
            }
            this.recheckAll(sigList);
            this.modified = false;
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error reading session file.\n" + e.getMessage(), e);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing session file.", e);
                }
            }
        }
    }

    public void startProcess(LocaleId srcLoc, LocaleId trgLoc) {
        this.checker.startProcess(srcLoc, trgLoc, this.params, this.issues);
    }

    public void processStartDocument(StartDocument startDoc, List<String> sigList) {
        this.checker.processStartDocument(startDoc, sigList);
    }

    public void processStartSubDocument(StartSubDocument startSubDoc) {
        this.checker.processStartSubDocument(startSubDoc);
    }

    public void processTextUnit(ITextUnit textUnit) {
        this.checker.processTextUnit(textUnit);
    }

    public void generateReport(String rootDir) {
        String finalPath = Util.fillRootDirectoryVariable(this.params.getOutputPath(), rootDir);
        String inputRoot = null;
        if (!this.params.getShowFullPath()) {
            inputRoot = this.buildIssuesDocRoot();
        }
        switch (this.params.getOutputType()) {
            case 1: {
                this.generateTabDelimitedReport(finalPath, inputRoot);
                break;
            }
            case 2: {
                this.generateXMLReport(finalPath, inputRoot);
                break;
            }
            default: {
                this.generateHTMLReport(finalPath, inputRoot);
            }
        }
    }

    private String buildIssuesDocRoot() {
        ArrayList<String> dirs = new ArrayList<String>(this.issues.size());
        for (Issue issue : this.issues) {
            dirs.add(Util.getDirectoryName(issue.getDocumentURI().getPath()));
        }
        if (!dirs.isEmpty()) {
            String root = Util.longestCommonDir(!Util.isOSCaseSensitive(), dirs.toArray(new String[0]));
            root = Util.ensureSeparator(root, true);
            return root;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHTMLReport(String finalPath, String inputRoot) {
        try (XMLWriter writer = null;){
            writer = new XMLWriter(finalPath);
            writer.writeStartDocument();
            writer.writeStartElement("html");
            writer.writeRawXML("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /><title>Quality Check Report</title><style type=\"text/css\">body { font-family: Verdana; font-size: smaller; }h1 { font-size: 110%; }h2 { font-size: 100%; }h3 { font-size: 100%; }p.s { font-family: Courier New, courier; font-size: 100%;   border: solid 1px; padding: 0.5em; margin-top:-0.7em; border-color: silver; background-color: #C0FFFF; }p.t { font-family: Courier New, courier; font-size: 100%; margin-top:-1.1em;   border: solid 1px; padding: 0.5em; border-color: silver; background-color: #C0FFC0; }span.hi { background-color: #FFFF00; }</style></head>");
            writer.writeStartElement("body");
            writer.writeLineBreak();
            writer.writeElementString("h1", "Quality Check Report");
            URI docId = null;
            String inputPath = null;
            for (Issue issue : this.issues) {
                if (!issue.getEnabled()) continue;
                if (docId == null || !docId.equals(issue.getDocumentURI())) {
                    if (docId != null) {
                        writer.writeRawXML("<hr />");
                    }
                    docId = issue.getDocumentURI();
                    inputPath = docId.getPath();
                    if (!this.params.getShowFullPath()) {
                        inputPath = inputPath.replaceFirst(inputRoot, "");
                    }
                    writer.writeElementString("p", "Input: " + inputPath);
                }
                Object position = String.format("ID=%s", issue.getTuId());
                if (issue.getTuName() != null) {
                    position = (String)position + " (" + issue.getTuName() + ")";
                }
                if (issue.getSegId() != null) {
                    position = (String)position + String.format(", segment=%s", issue.getSegId());
                }
                writer.writeStartElement("p");
                writer.writeString((String)position + ":");
                writer.writeRawXML("<br />");
                writer.writeString(issue.getMessage());
                writer.writeEndElementLineBreak();
                writer.writeRawXML("<p class='s'>");
                writer.writeRawXML("S: '" + this.highlight(issue.getSource(), issue.getSourceStart(), issue.getSourceEnd()) + "'");
                writer.writeRawXML("</p><p class='t'>");
                writer.writeRawXML("T: '" + this.highlight(issue.getTarget(), issue.getTargetStart(), issue.getTargetEnd()) + "'");
                writer.writeRawXML("</p>");
                writer.writeLineBreak();
            }
            if (docId == null) {
                writer.writeRawXML("<p>No issue detected.</p>");
            }
            writer.writeEndElementLineBreak();
            writer.writeEndElementLineBreak();
            writer.writeEndDocument();
        }
    }

    private void generateTabDelimitedReport(String finalPath, String inputRoot) {
        try (PrintWriter writer = new PrintWriter(new File(finalPath), "UTF-8");){
            writer.println("Quality Check Report\t\t\t");
            URI docId = null;
            for (Issue issue : this.issues) {
                if (!issue.getEnabled()) continue;
                if (docId == null || !docId.equals(issue.getDocumentURI())) {
                    docId = issue.getDocumentURI();
                    String inputPath = docId.getPath();
                    if (!this.params.getShowFullPath()) {
                        inputPath = inputPath.replaceFirst(inputRoot, "");
                    }
                    writer.println(inputPath + "\t\t\t");
                }
                Object position = String.format("ID=%s", issue.getTuId());
                if (issue.getTuName() != null) {
                    position = (String)position + " (" + issue.getTuName() + ")";
                }
                if (issue.getSegId() != null) {
                    position = (String)position + String.format(", segment=%s", issue.getSegId());
                }
                writer.print((String)position + "\t");
                writer.print(issue.getMessage() + "\t");
                writer.print(this.escape(issue.getSource()) + "\t");
                writer.println(this.escape(issue.getTarget()));
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error when creating the report.\n" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateXMLReport(String finalPath, String inputRoot) {
        try (XMLWriter writer = null;){
            writer = new XMLWriter(finalPath);
            writer.writeStartDocument();
            writer.writeStartElement("qualityCheckReport");
            writer.writeLineBreak();
            writer.writeStartElement("issues");
            writer.writeLineBreak();
            URI docId = null;
            String inputPath = null;
            for (Issue issue : this.issues) {
                if (!issue.getEnabled()) continue;
                if (docId == null || !docId.equals(issue.getDocumentURI())) {
                    if (docId != null) {
                        writer.writeRawXML("<hr />");
                    }
                    docId = issue.getDocumentURI();
                    inputPath = docId.getPath();
                    if (!this.params.getShowFullPath()) {
                        inputPath = inputPath.replaceFirst(inputRoot, "");
                    }
                }
                writer.writeStartElement("issue");
                writer.writeLineBreak();
                QualityCheckSession.writeIndentedElementString(writer, "input", inputPath);
                QualityCheckSession.writeIndentedElementString(writer, "tuName", issue.getTuName());
                QualityCheckSession.writeIndentedElementString(writer, "tuId", issue.getTuId());
                QualityCheckSession.writeIndentedElementString(writer, "segId", issue.getSegId());
                QualityCheckSession.writeIndentedElementString(writer, "severity", Integer.toString(issue.getDisplaySeverity()));
                QualityCheckSession.writeIndentedElementString(writer, "issueType", issue.getIssueType().toString());
                QualityCheckSession.writeIndentedElementString(writer, "message", issue.getMessage());
                QualityCheckSession.writeIndentedElementStringHilite(writer, "source", issue.getSource(), issue.getSourceStart(), issue.getSourceEnd());
                QualityCheckSession.writeIndentedElementStringHilite(writer, "target", issue.getTarget(), issue.getTargetStart(), issue.getTargetEnd());
                writer.writeEndElementLineBreak();
            }
            writer.writeEndElementLineBreak();
            writer.writeEndElementLineBreak();
            writer.writeEndDocument();
        }
    }

    private static void writeIndentedElementString(XMLWriter writer, String element, String text) {
        writer.writeString("\t");
        writer.writeElementString(element, text);
        writer.writeLineBreak();
    }

    private static void writeIndentedElementStringHilite(XMLWriter writer, String element, String text, int start, int end) {
        if (end > 0) {
            writer.writeString("\t");
            writer.writeStartElement(element);
            writer.writeString(text.substring(0, start));
            writer.writeElementString("hi", text.substring(start, end));
            writer.writeString(text.substring(end));
            writer.writeEndElementLineBreak();
        } else {
            QualityCheckSession.writeIndentedElementString(writer, element, text);
        }
    }

    private String escape(String text) {
        return text.replaceAll("\t", "\\t");
    }

    private String highlight(String text, int start, int end) {
        if (end > 0) {
            StringBuilder buf = new StringBuilder(text);
            buf.insert(start, '\u0017');
            buf.insert(end + 1, '\u0018');
            String tmp = Util.escapeToXML(buf.toString(), 0, false, null);
            tmp = tmp.replace("\u0017", "<span class='hi'>");
            tmp = tmp.replace("\u0018", "</span>");
            return tmp.replace("\n", "<br/>");
        }
        return Util.escapeToXML(text, 0, false, null).replace("\n", "<br/>");
    }

    private int getLongStringBlockCount(String data) {
        int r = data.length() % 21666;
        int n = data.length() / 21666;
        return n + (r > 0 ? 1 : 0);
    }

    private void writeLongString(DataOutputStream dos, String data) throws IOException {
        int r = data.length() % 21666;
        int n = data.length() / 21666;
        int count = n + (r > 0 ? 1 : 0);
        dos.writeInt(count);
        int pos = 0;
        for (int i = 0; i < n; ++i) {
            dos.writeUTF(data.substring(pos, pos + 21666));
            pos += 21666;
        }
        if (r > 0) {
            dos.writeUTF(data.substring(pos));
        }
    }

    private String readLongString(DataInputStream dis) throws IOException {
        StringBuilder tmp = new StringBuilder();
        int count = dis.readInt();
        for (int i = 0; i < count; ++i) {
            tmp.append(dis.readUTF());
        }
        return tmp.toString();
    }
}

