/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Pattern;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.NSContext;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.CanReorder;
import net.sf.okapi.lib.xliff2.core.CloneFactory;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.ExtAttribute;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithNotes;
import net.sf.okapi.lib.xliff2.core.IWithStore;
import net.sf.okapi.lib.xliff2.core.InheritedData;
import net.sf.okapi.lib.xliff2.core.InvalidPositionException;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.PCont;
import net.sf.okapi.lib.xliff2.core.Store;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Tags;
import net.sf.okapi.lib.xliff2.its.AnnotatorsRef;
import net.sf.okapi.lib.xliff2.its.ITSWriter;
import net.sf.okapi.lib.xliff2.its.TermTag;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriterException;

public class Fragment
implements Iterable<Object>,
Appendable {
    public static final char CODE_OPENING = '\ue101';
    public static final char CODE_CLOSING = '\ue102';
    public static final char CODE_STANDALONE = '\ue103';
    public static final char MARKER_OPENING = '\ue104';
    public static final char MARKER_CLOSING = '\ue105';
    public static final char PCONT_STANDALONE = '\ue106';
    public static final int TAGREF_BASE = 57616;
    public static final int TAGREF_MAX = 6127;
    public static final Pattern TAGREF_REGEX = Pattern.compile("[\ue101\ue102\ue103\ue104\ue105\ue106].");
    private boolean isTarget;
    private StringBuilder ctext;
    private Tags tags;
    private Directionality dir = Directionality.INHERITED;
    private transient ITSWriter itsWriter;

    public static int toKey(int c1, int c2) {
        return c1 << 16 | c2;
    }

    public static char toChar1(int key) {
        return (char)(key >> 16);
    }

    public static char toChar2(int key) {
        return (char)key;
    }

    public static String toRef(int key) {
        return "" + (char)(key >> 16) + (char)key;
    }

    public static boolean isChar1(char value) {
        switch (value) {
            case '\ue101': 
            case '\ue102': 
            case '\ue103': 
            case '\ue104': 
            case '\ue105': 
            case '\ue106': {
                return true;
            }
        }
        return false;
    }

    public static boolean isCTag(char value) {
        switch (value) {
            case '\ue101': 
            case '\ue102': 
            case '\ue103': {
                return true;
            }
        }
        return false;
    }

    public static boolean hasContentAfter(String codedText, int position) {
        for (int i = position; i < codedText.length(); ++i) {
            if (Fragment.isChar1(codedText.charAt(position))) {
                switch (codedText.charAt(position)) {
                    case '\ue104': 
                    case '\ue105': {
                        break;
                    }
                    default: {
                        return true;
                    }
                }
                ++i;
                continue;
            }
            return true;
        }
        return false;
    }

    public static int getCodedTextPosition(CharSequence codedText, int plainTextPosition, boolean leftOfTag) {
        int ct;
        int pt = 0;
        for (ct = 0; ct < codedText.length(); ++ct) {
            if (Fragment.isChar1(codedText.charAt(ct))) {
                if (pt == plainTextPosition && leftOfTag) {
                    return ct;
                }
                ++ct;
                continue;
            }
            if (pt == plainTextPosition) {
                return ct;
            }
            ++pt;
        }
        return ct;
    }

    public Fragment(Fragment original, Store store, boolean target) {
        this(store, target);
        this.dir = original.dir;
        Tags oriTags = original.getTags();
        Tags destTags = this.getTags();
        StringBuilder tmp = new StringBuilder(original.getCodedText());
        for (int i = 0; i < tmp.length(); ++i) {
            int key;
            char ch = tmp.charAt(i);
            if (!Fragment.isChar1(ch)) continue;
            if (ch == '\ue106') {
                PCont pcont = oriTags.getPCont(tmp, i);
                StringBuilder pct = new StringBuilder(pcont.getCodedText());
                for (int j = 0; j < pct.length(); ++j) {
                    if (!Fragment.isChar1(pct.charAt(j))) continue;
                    Tag tag = oriTags.get(pct, j);
                    key = this.tags.add(CloneFactory.create(tag, destTags));
                    pct.replace(j, j + 2, Fragment.toRef(key));
                    ++j;
                }
                key = this.tags.add(new PCont(pct.toString()));
            } else {
                Tag tag = oriTags.get(tmp, i);
                key = this.tags.add(CloneFactory.create(tag, destTags));
            }
            tmp.replace(i, i + 2, Fragment.toRef(key));
            ++i;
        }
        this.setCodedText(tmp.toString());
    }

    public Fragment(Store store, boolean target) {
        if (store == null) {
            throw new InvalidParameterException("The store parameter cannot be null.");
        }
        this.isTarget = target;
        this.ctext = new StringBuilder();
        this.tags = this.isTarget ? store.getTargetTags() : store.getSourceTags();
    }

    public Fragment(Store store, boolean target, String plainText) {
        this(store, target);
        this.ctext = new StringBuilder(plainText);
    }

    public String toString() {
        return this.ctext.toString();
    }

    public String getPlainText() {
        return TAGREF_REGEX.matcher(new String(this.ctext)).replaceAll("");
    }

    public String getCodedText() {
        return this.ctext.toString();
    }

    public void setCodedText(String codedText) {
        this.ctext = new StringBuilder(codedText);
    }

    public Tags getTags() {
        return this.tags;
    }

    public List<Tag> getOwnTags() {
        if (this.tags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (int i = 0; i < this.ctext.length(); ++i) {
            if (!Fragment.isChar1(this.ctext.charAt(i))) continue;
            list.add(this.tags.get(Fragment.toKey(this.ctext.charAt(i), this.ctext.charAt(++i))));
        }
        return list;
    }

    public Map<Tag, Integer> getOwnTagsStatus() {
        List<Tag> ownTags = this.getOwnTags();
        HashMap<Tag, Integer> status = new HashMap<Tag, Integer>(ownTags.size());
        Stack<Tag> stack = new Stack<Tag>();
        for (Tag tag : ownTags) {
            switch (tag.getTagType()) {
                case OPENING: {
                    stack.push(tag);
                    status.put(tag, 0);
                    break;
                }
                case CLOSING: {
                    if (!stack.isEmpty() && ((Tag)stack.peek()).getId().equals(tag.getId())) {
                        status.put((Tag)stack.pop(), 2);
                        status.put(tag, 2);
                        break;
                    }
                    if (this.tags.getOpeningTag(tag.getId()) != null) {
                        status.put(tag, 1);
                        break;
                    }
                    status.put(tag, 0);
                    break;
                }
            }
        }
        while (!stack.isEmpty()) {
            Tag tag = (Tag)stack.pop();
            if (this.tags.getClosingTag(tag.getId()) == null) continue;
            status.put(tag, 1);
        }
        return status;
    }

    public Tag getTag(CharSequence ctext, int pos) {
        return this.tags.get(ctext, pos);
    }

    public CTag getCTag(CharSequence ctext, int pos) {
        return this.tags.getCTag(ctext, pos);
    }

    public MTag getMTag(CharSequence ctext, int pos) {
        return this.tags.getMTag(ctext, pos);
    }

    public Store getStore() {
        return this.tags.getStore();
    }

    public Tag getTag(int key) {
        return this.tags.get(key);
    }

    private String getTagId(Tag tag, boolean forceUniqueIds) {
        int prefixEnd;
        String tagId = tag.getId();
        if (forceUniqueIds && (prefixEnd = tagId.indexOf(45)) != -1 && prefixEnd < tagId.length()) {
            tagId = tagId.substring(prefixEnd + 1);
        }
        return tagId;
    }

    public String toXLIFF(Stack<NSContext> nsStack, Stack<InheritedData> context, boolean withOriginalData, boolean forceUniqueIds) {
        StringBuilder tmp = new StringBuilder();
        ArrayList<String> verified = new ArrayList<String>();
        List<AbstractMap.SimpleEntry<String, AnnotatorsRef>> annotRefs = null;
        block7: for (int i = 0; i < this.ctext.length(); ++i) {
            MTag mtag;
            String tagId;
            CTag ctag;
            char ch = this.ctext.charAt(i);
            if (ch == '\ue101') {
                ctag = (CTag)this.tags.get(this.ctext, i);
                CTag closing = null;
                String tagId2 = this.getTagId(ctag, forceUniqueIds);
                if ((closing = (CTag)this.getWellFormedClosing(ctag, ++i)) != null) {
                    tmp.append("<pc id=\"" + tagId2 + "\"");
                    verified.add(ctag.getId());
                    if (ctag.getCanOverlap()) {
                        tmp.append(" canOverlap=\"yes\"");
                    }
                } else {
                    tmp.append(String.format("<sc id=\"%s\"", tagId2));
                    if (!ctag.getCanOverlap()) {
                        tmp.append(" canOverlap=\"no\"");
                    }
                    if (this.getClosingTag(ctag) == null) {
                        tmp.append(" isolated=\"yes\"");
                    }
                }
                Fragment.printCommonAttributes(ctag, this.tags, tmp, closing, withOriginalData);
                if (withOriginalData && ctag.hasData()) {
                    String ending = closing == null ? "" : "Start";
                    tmp.append(String.format(" dataRef%s=\"%s\"", ending, this.tags.getStore().getIdForData(ctag)));
                }
                Fragment.printExtAttributes(ctag, tmp, nsStack);
                tmp.append(closing == null ? "/>" : ">");
                continue;
            }
            if (ch == '\ue102') {
                ctag = (CTag)this.tags.get(this.ctext, i);
                ++i;
                tagId = this.getTagId(ctag, forceUniqueIds);
                if (verified.contains(ctag.getId())) {
                    tmp.append("</pc>");
                    continue;
                }
                tmp.append("<ec");
                if (!this.unitHasOpening(ctag)) {
                    tmp.append(String.format(" id=\"%s\"", tagId));
                    tmp.append(" isolated=\"yes\"");
                } else {
                    tmp.append(" startRef=\"" + tagId + "\"");
                }
                if (!ctag.getCanOverlap()) {
                    tmp.append(" canOverlap=\"no\"");
                }
                Fragment.printCommonAttributes(ctag, this.tags, tmp, null, false);
                if (withOriginalData && ctag.hasData()) {
                    tmp.append(String.format(" dataRef=\"%s\"", this.tags.getStore().getIdForData(ctag)));
                }
                Fragment.printExtAttributes(ctag, tmp, nsStack);
                tmp.append("/>");
                continue;
            }
            if (ch == '\ue103') {
                ctag = (CTag)this.tags.get(this.ctext, i);
                ++i;
                tagId = this.getTagId(ctag, forceUniqueIds);
                tmp.append(String.format("<ph id=\"%s\"", tagId));
                Fragment.printCommonAttributes(ctag, this.tags, tmp, null, false);
                if (withOriginalData && ctag.hasData()) {
                    tmp.append(String.format(" dataRef=\"%s\"", this.tags.getStore().getIdForData(ctag)));
                }
                Fragment.printExtAttributes(ctag, tmp, nsStack);
                tmp.append("/>");
                continue;
            }
            if (ch == '\ue104') {
                MTag closing;
                mtag = (MTag)this.tags.get(this.ctext, i);
                tagId = this.getTagId(mtag, forceUniqueIds);
                if ((closing = (MTag)this.getWellFormedClosing(mtag, ++i)) != null) {
                    tmp.append(String.format("<%s id=\"%s\"", "mrk", tagId));
                } else {
                    tmp.append(String.format("<%s id=\"%s\"", "sm", tagId));
                }
                if (!mtag.getType().equals("generic")) {
                    tmp.append(" type=\"" + mtag.getType() + "\"");
                }
                if (mtag.getTranslate() != null) {
                    tmp.append(" translate=\"" + (mtag.getTranslate() != false ? "yes" : "no") + "\"");
                }
                if (!Util.isNoE(mtag.getValue())) {
                    tmp.append(" value=\"" + Util.toXML(mtag.getValue(), true) + "\"");
                }
                if (!Util.isNoE(mtag.getRef())) {
                    tmp.append(" ref=\"" + Util.toXML(mtag.getRef(), true) + "\"");
                }
                if (this.itsWriter == null) {
                    this.itsWriter = new ITSWriter();
                }
                if (annotRefs == null) {
                    annotRefs = this.itsWriter.createAnnotatorsRefList(context);
                }
                AnnotatorsRef amAR = this.itsWriter.createAnnotatorsRef(mtag);
                annotRefs.add(new AbstractMap.SimpleEntry<String, AnnotatorsRef>(tagId, amAR));
                tmp.append(this.itsWriter.outputAttributes(mtag, amAR, annotRefs.get(annotRefs.size() - 2).getValue()));
                Fragment.printExtAttributes(mtag, tmp, nsStack);
                if (closing != null) {
                    verified.add(mtag.getId());
                    tmp.append(">");
                    continue;
                }
                tmp.append("/>");
                continue;
            }
            if (ch == '\ue105') {
                mtag = (MTag)this.tags.get(this.ctext, i);
                ++i;
                tagId = this.getTagId(mtag, forceUniqueIds);
                if (verified.contains(mtag.getId())) {
                    tmp.append("</mrk>");
                } else {
                    tmp.append("<em startRef=\"" + tagId + "\"/>");
                }
                if (annotRefs == null) continue;
                String id = tagId;
                for (AbstractMap.SimpleEntry simpleEntry : annotRefs) {
                    if (!id.equals(simpleEntry.getKey())) continue;
                    annotRefs.remove(simpleEntry);
                    continue block7;
                }
                continue;
            }
            if (ch == '\ue106') {
                tmp.append("<WARNING:HIDDEN-PROTECTED-CONTENT/>");
                ++i;
                continue;
            }
            switch (ch) {
                case '\r': {
                    tmp.append("&#13;");
                    continue block7;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block7;
                }
                case '>': {
                    tmp.append("&gt;");
                    continue block7;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block7;
                }
                case '\t': 
                case '\n': {
                    tmp.append(ch);
                    continue block7;
                }
                default: {
                    if (ch > '\u001f' && ch < '\ud800') {
                        tmp.append(ch);
                        continue block7;
                    }
                    if (Character.isHighSurrogate(ch)) {
                        tmp.append(Character.toChars(this.ctext.codePointAt(i)));
                        ++i;
                        continue block7;
                    }
                    if (ch < ' ' || ch > '\ud7ff' && ch < '\ue000' || ch == '\ufffe' || ch == '\uffff') {
                        tmp.append(String.format("<cp hex=\"%04X\"/>", ch));
                        continue block7;
                    }
                    tmp.append(ch);
                }
            }
        }
        return tmp.toString();
    }

    public Tag getClosingTag(Tag tag) {
        if (this.tags == null) {
            return null;
        }
        return this.tags.getClosingTag(tag);
    }

    public Tag getOpeningTag(Tag tag) {
        if (this.tags == null) {
            return null;
        }
        return this.tags.getOpeningTag(tag);
    }

    public int getClosingPosition(Tag opening) {
        if (this.tags == null) {
            return -1;
        }
        Tag closing = this.tags.getClosingTag(opening);
        if (closing == null) {
            return -1;
        }
        return this.ctext.indexOf(Fragment.toRef(this.tags.getKey(closing)));
    }

    public boolean unitHasOpening(CTag ctag) {
        if (this.tags == null) {
            return false;
        }
        return this.tags.getOpeningTag(ctag) != null;
    }

    public static void printCommonAttributes(CTag code, Tags tags, StringBuilder tmp, CTag closing, boolean outputDataRefEnd) {
        String ending;
        if (code.getType() != null && !code.getType().isEmpty()) {
            tmp.append(" type=\"" + code.getType() + "\"");
        }
        if (code.getSubType() != null && !code.getSubType().isEmpty()) {
            if (code.getType() == null || code.getType().isEmpty()) {
                throw new XLIFFWriterException("You must specify a type if you specify a subType.");
            }
            tmp.append(" subType=\"" + code.getSubType() + "\"");
        }
        if (!code.getCanCopy()) {
            tmp.append(" canCopy=\"no\"");
        }
        if (!code.getCanDelete()) {
            tmp.append(" canDelete=\"no\"");
        }
        if (code.getCanReorder() != CanReorder.YES) {
            tmp.append(String.format(" %s=\"%s\"", "canReorder", code.getCanReorder() == CanReorder.FIRSTNO ? "firstNo" : "no"));
        }
        String string = ending = closing == null ? "" : "Start";
        if (!code.getEquiv().isEmpty()) {
            tmp.append(String.format(" equiv%s=\"%s\"", ending, Util.toXML(code.getEquiv(), true)));
        }
        if (code.getDisp() != null && !code.getDisp().isEmpty()) {
            tmp.append(String.format(" disp%s=\"%s\"", ending, Util.toXML(code.getDisp(), true)));
        }
        if (code.getSubFlows() != null && !code.getSubFlows().isEmpty()) {
            tmp.append(String.format(" subFlows%s=\"%s\"", ending, code.getSubFlows()));
        }
        if (closing != null) {
            if (!closing.getEquiv().isEmpty()) {
                tmp.append(String.format(" equivEnd=\"%s\"", Util.toXML(closing.getEquiv(), true)));
            }
            if (closing.getDisp() != null && !closing.getDisp().isEmpty()) {
                tmp.append(String.format(" dispEnd=\"%s\"", Util.toXML(closing.getDisp(), true)));
            }
            if (closing.getSubFlows() != null && !closing.getSubFlows().isEmpty()) {
                tmp.append(String.format(" subFlowsEnd=\"%s\"", closing.getSubFlows()));
            }
            if (outputDataRefEnd && closing.hasData()) {
                tmp.append(String.format(" dataRefEnd=\"%s\"", tags.getStore().getIdForData(closing)));
            }
        }
    }

    public static void printExtAttributes(Tag tag, StringBuilder output, Stack<NSContext> nsStack) {
        String prefix;
        if (!tag.hasExtAttribute()) {
            return;
        }
        ExtAttributes attributes = tag.getExtAttributes();
        NSContext nsCtx = null;
        if (nsStack != null) {
            nsCtx = nsStack.push(nsStack.peek().clone());
            for (String namespaceURI : attributes.getNamespaces()) {
                if (namespaceURI.isEmpty() || nsStack.peek().getPrefix(namespaceURI) != null || (prefix = attributes.getNamespacePrefix(namespaceURI)) == null) continue;
                output.append(" xmlns" + (String)(prefix.isEmpty() ? "" : ":" + prefix) + "=\"" + namespaceURI + "\"");
                nsCtx.put(prefix, namespaceURI);
            }
        } else {
            for (String namespaceURI : attributes.getNamespaces()) {
                if (namespaceURI.isEmpty() || (prefix = attributes.getNamespacePrefix(namespaceURI)) == null) continue;
                output.append(" xmlns:" + prefix + "=\"" + namespaceURI + "\"");
            }
        }
        for (ExtAttribute att : attributes) {
            if (nsCtx != null) {
                prefix = nsCtx.getPrefix(att.getNamespaceURI());
                output.append(" " + (String)(prefix.isEmpty() ? "" : prefix + ":") + att.getLocalPart() + "=\"" + Util.toXML(att.getValue(), true) + "\"");
                continue;
            }
            output.append(" " + (String)(att.getPrefix().isEmpty() ? "" : att.getPrefix() + ":") + att.getLocalPart() + "=\"" + Util.toXML(att.getValue(), true) + "\"");
        }
        if (nsStack != null) {
            nsStack.pop();
        }
    }

    public String toXLIFF() {
        return this.toXLIFF(null, null, false, false);
    }

    public boolean isEmpty() {
        return this.ctext.length() == 0;
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public boolean hasTag() {
        if (this.tags.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.ctext.length(); ++i) {
            if (!Fragment.isChar1(this.ctext.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public Tag getWellFormedClosing(Tag opening, int from) {
        Stack<String> stack = new Stack<String>();
        for (int i = from; i < this.ctext.length(); ++i) {
            Tag tag;
            char ch = this.ctext.charAt(i);
            if (ch == '\ue101' || ch == '\ue104') {
                tag = this.tags.get(this.ctext, i);
                ++i;
                stack.push(tag.getId());
                continue;
            }
            if (ch == '\ue102' || ch == '\ue105') {
                tag = this.tags.get(this.ctext, i);
                ++i;
                if (tag.getId().equals(opening.getId())) {
                    if (stack.isEmpty()) {
                        return tag;
                    }
                    return null;
                }
                if (stack.isEmpty()) {
                    return null;
                }
                stack.remove(tag.getId());
                continue;
            }
            if (ch != '\ue103') continue;
            ++i;
        }
        return null;
    }

    @Override
    public Fragment append(char ch) {
        this.ctext.append(ch);
        return this;
    }

    @Override
    public Fragment append(CharSequence plainText) {
        this.ctext.append(plainText);
        return this;
    }

    @Override
    public Fragment append(CharSequence plainText, int start, int end) {
        this.ctext.append(plainText.subSequence(start, end));
        return this;
    }

    public Tag append(Tag tag) {
        this.ctext.append(Fragment.toRef(this.tags.add(tag)));
        return tag;
    }

    public MTag openMarkerSpan(String id, String type) {
        if (id == null) {
            id = this.tags.getStore().suggestId(false);
        }
        MTag mtag = new MTag(id, type);
        this.ctext.append(Fragment.toRef(this.tags.add(mtag)));
        return mtag;
    }

    public MTag closeMarkerSpan(String id) {
        if (this.tags == null) {
            throw new XLIFFException("There are no opening tags in this unit.");
        }
        Tag tag = this.tags.getOpeningTag(id);
        if (tag == null) {
            throw new XLIFFException(String.format("Opening tag for id='%s' not found.", id));
        }
        if (!(tag instanceof MTag)) {
            throw new XLIFFException(String.format("Opening tag for id='%s' is not for a marker.", id));
        }
        MTag closing = new MTag((MTag)tag);
        this.ctext.append(Fragment.toRef(this.tags.add(closing)));
        return closing;
    }

    public CTag append(TagType tagType, String id, String data, boolean canOverlap) {
        CTag ctag;
        if (id == null) {
            id = this.tags.getStore().suggestId(false);
        }
        Tag opposite = null;
        if (tagType != TagType.STANDALONE) {
            opposite = tagType == TagType.OPENING ? this.tags.getClosingTag(id) : this.tags.getOpeningTag(id);
        }
        if (opposite == null) {
            ctag = new CTag(null, tagType, id, data);
        } else {
            CTag tmp = (CTag)opposite;
            ctag = new CTag(tmp, data);
            switch (tmp.getTagType()) {
                case OPENING: {
                    if (tmp.getCanReorder() == CanReorder.FIRSTNO) {
                        ctag.setCanReorder(CanReorder.NO);
                        break;
                    }
                }
                default: {
                    ctag.setCanReorder(tmp.getCanReorder());
                }
            }
        }
        this.ctext.append(Fragment.toRef(this.tags.add(ctag)));
        if (opposite == null) {
            ctag.setCanOverlap(canOverlap);
        }
        return ctag;
    }

    public Fragment append(Fragment fragment) {
        if (this == fragment) {
            throw new XLIFFException("Recursive append() on a fragment.");
        }
        for (Object obj : fragment) {
            if (obj instanceof Tag) {
                this.append(CloneFactory.create((Tag)obj, this.getTags()));
                continue;
            }
            if (obj instanceof PCont) {
                throw new XLIFFException("Fragment.append(Fragment) with hidden protected content is not supported yet.");
            }
            this.append((String)obj);
        }
        return this;
    }

    public int annotate(int start, int end, String type, String value, String ref) {
        MTag tag = new MTag(true, this.getStore().suggestId(false), type);
        if ("term".equals(type) || "its:term-no".equals(type)) {
            tag = new TermTag(tag, type, null);
        }
        tag.setValue(value);
        tag.setRef(ref);
        return this.annotate(start, end, tag);
    }

    public int annotate(int start, int end, MTag opening) {
        int initial = this.ctext.length();
        if (end == -1) {
            end = this.ctext.length();
        }
        this.checkPosition(start);
        this.checkPosition(end);
        int key = this.tags.add(opening);
        this.ctext.insert(start, Fragment.toRef(key));
        MTag closing = new MTag(opening);
        key = this.tags.add(closing);
        this.ctext.insert(end + 2, Fragment.toRef(key));
        return this.ctext.length() - initial;
    }

    public Note annotateWithNote(int start, int end, String noteContent) {
        IWithStore parent = this.getStore().getParent();
        if (!(parent instanceof IWithNotes)) {
            throw new XLIFFException("Cannot attach a note in to " + parent.getClass().getCanonicalName());
        }
        IWithNotes holder = (IWithNotes)((Object)parent);
        MTag opening = new MTag(true, this.getStore().suggestId(false), "comment");
        this.annotate(start, end, opening);
        Note note = new Note(noteContent);
        note.setId(UUID.randomUUID().toString());
        holder.addNote(note);
        opening.setRef("#n=" + note.getId());
        return note;
    }

    public MTag getOrCreateMarker(int start, int end, String matchingType, String typeForNew) {
        int pos;
        if (end == -1) {
            end = this.ctext.length();
        }
        this.checkPosition(start);
        this.checkPosition(end);
        boolean found = false;
        MTag opening = null;
        Tag closing = null;
        if (start > 1 && this.ctext.charAt(start - 2) == '\ue104') {
            opening = (MTag)this.tags.get(this.ctext, start - 2);
        } else if (this.ctext.charAt(start) == '\ue104') {
            opening = (MTag)this.tags.get(this.ctext, start);
        }
        if (opening != null && (closing = this.tags.getClosingTag(opening)) != null && (end == (pos = this.ctext.indexOf(Fragment.toRef(this.tags.getKey(closing)))) || end == pos + 2)) {
            found = matchingType != null ? matchingType.equals(opening.getType()) : true;
        }
        if (!found) {
            if (typeForNew == null) {
                throw new InvalidParameterException("You must define the typeForNew parameter.");
            }
            opening = new MTag(true, this.getStore().suggestId(false), typeForNew);
            this.annotate(start, end, opening);
        }
        return opening;
    }

    public Fragment remove(Tag tag) {
        if (this.tags == null) {
            throw new XLIFFException("There is no tag in this fragment.");
        }
        int key = this.tags.getKey(tag);
        if (key == -1) {
            throw new XLIFFException(String.format("There is no tag for id='%s' and type='%s' in this fragment.", tag.getId(), tag.getType()));
        }
        for (int i = 0; i < this.ctext.length(); ++i) {
            char ch = this.ctext.charAt(i);
            if (ch == '\ue106') {
                PCont pcont = this.tags.getPCont(Fragment.toKey(ch, this.ctext.charAt(i + 1)));
                StringBuilder pct = new StringBuilder(pcont.getCodedText());
                for (int j = 0; j < pct.length(); ++j) {
                    char pch = pct.charAt(j);
                    if (!Fragment.isChar1(pch) || key != Fragment.toKey(pch, pct.charAt(++j))) continue;
                    pct.delete(j - 1, j + 1);
                    pcont.setCodedText(pct.toString());
                    this.tags.remove(key);
                    return this;
                }
                continue;
            }
            if (!Fragment.isChar1(ch) || key != Fragment.toKey(ch, this.ctext.charAt(++i))) continue;
            this.ctext.delete(i - 1, i + 1);
            this.tags.remove(key);
            return this;
        }
        return this;
    }

    public Fragment delete(int start, int end) {
        this.checkPosition(start);
        this.checkPosition(end);
        for (int i = start; i < end; ++i) {
            char ch = this.ctext.charAt(i);
            if (ch == '\ue106') {
                int pkey = Fragment.toKey(ch, this.ctext.charAt(++i));
                PCont pcont = this.tags.getPCont(pkey);
                StringBuilder pct = new StringBuilder(pcont.getCodedText());
                for (int j = 0; j < pct.length(); ++j) {
                    char pch = pct.charAt(j);
                    if (!Fragment.isChar1(pch)) continue;
                    this.tags.remove(Fragment.toKey(pch, pct.charAt(++j)));
                }
                this.tags.removePCont(pkey);
                continue;
            }
            if (!Fragment.isChar1(ch)) continue;
            this.tags.remove(Fragment.toKey(ch, this.ctext.charAt(++i)));
        }
        this.ctext.delete(start, end);
        return this;
    }

    @Override
    public Iterator<Object> iterator() {
        return new ContentIterable<Object>(Object.class).iterator();
    }

    public <T> Iterable<T> getIterable(Class<T> type) {
        return new ContentIterable<T>(type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ctext == null ? 0 : this.ctext.toString().hashCode());
        result = 31 * result + (this.dir == null ? 0 : this.dir.hashCode());
        result = 31 * result + (this.isTarget ? 1231 : 1237);
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Fragment fragment = (Fragment)object;
        Iterator<Object> thisIter = this.iterator();
        Iterator<Object> thatIter = fragment.iterator();
        while (thisIter.hasNext()) {
            if (!thatIter.hasNext()) {
                return false;
            }
            Object thisObj = thisIter.next();
            Object thatObj = thatIter.next();
            if (thisObj instanceof String) {
                if (!(thatObj instanceof String)) {
                    return false;
                }
                if (thisObj.equals(thatObj)) continue;
                return false;
            }
            if (thatObj instanceof String) {
                return false;
            }
            if (thisObj.equals(thatObj)) continue;
            return false;
        }
        return !thatIter.hasNext();
    }

    public Directionality getDir(boolean resolved) {
        if (resolved && this.dir == Directionality.INHERITED) {
            if (this.isTarget) {
                return this.tags.getStore().getTargetDir();
            }
            return this.tags.getStore().getSourceDir();
        }
        return this.dir;
    }

    public void setDir(Directionality dir) {
        this.dir = dir;
    }

    public void showProtectedContent() {
        for (int i = 0; i < this.ctext.length(); ++i) {
            char ch = this.ctext.charAt(i);
            if (ch == '\ue106') {
                int pkey = Fragment.toKey(ch, this.ctext.charAt(i + 1));
                PCont pcont = this.tags.getPCont(pkey);
                this.ctext.replace(i, i + 2, pcont.getCodedText());
                i += pcont.getCodedText().length() - 1;
                this.tags.removePCont(pkey);
                continue;
            }
            if (!Fragment.isChar1(ch)) continue;
            ++i;
        }
    }

    public void checkPosition(int position) {
        if (position > 0 && Fragment.isChar1(this.ctext.charAt(position - 1))) {
            throw new InvalidPositionException(String.format("Position %d is inside a tag reference.", position));
        }
    }

    public void clear() {
        for (int i = 0; i < this.ctext.length(); ++i) {
            char ch = this.ctext.charAt(i);
            if (!Fragment.isChar1(ch)) continue;
            if (ch == '\ue106') {
                int pkey = Fragment.toKey(ch, this.ctext.charAt(++i));
                String pct = this.tags.getPCont(pkey).getCodedText();
                for (int j = 0; j < pct.length(); ++j) {
                    char pch = pct.charAt(j);
                    if (!Fragment.isChar1(pch)) continue;
                    this.tags.remove(Fragment.toKey(pch, pct.charAt(++j)));
                }
                this.tags.removePCont(pkey);
                continue;
            }
            this.tags.remove(Fragment.toKey(ch, this.ctext.charAt(++i)));
        }
        this.ctext = new StringBuilder();
    }

    public int getCodedTextPosition(int plainTextPosition, boolean leftOfTag) {
        return Fragment.getCodedTextPosition(this.ctext, plainTextPosition, leftOfTag);
    }

    public Fragment insert(CharSequence plainText, int offset) {
        this.checkPosition(offset);
        this.ctext.insert(offset, plainText);
        return this;
    }

    public CTag insert(TagType tagType, String type, String id, String data, int offset, boolean connect, boolean allowOrphan) {
        CTag ctag;
        if (id == null) {
            if (connect && !allowOrphan) {
                throw new InvalidParameterException("Cannot have auto-generated ID when requesting to link to an existing code and not allowing orphan.");
            }
            id = this.tags.getStore().suggestId(false);
        }
        if (offset < 0 || offset > this.ctext.length()) {
            offset = -1;
        } else {
            this.checkPosition(offset);
        }
        Tag opposite = null;
        if (connect && tagType != TagType.STANDALONE && (opposite = tagType == TagType.OPENING ? this.tags.getClosingTag(id) : this.tags.getOpeningTag(id)) == null && !allowOrphan) {
            throw new InvalidParameterException(String.format("Cannot add closing/opening code because opening/closing code for id '%s' does not exist.", id));
        }
        if (opposite == null) {
            ctag = new CTag(null, tagType, id, data);
        } else {
            CTag tmp = (CTag)opposite;
            ctag = new CTag(tmp, data);
            ctag.setCanReorder(tmp.getCanReorder());
        }
        if (offset == -1) {
            this.ctext.append(Fragment.toRef(this.tags.add(ctag)));
        } else {
            this.ctext.insert(offset, Fragment.toRef(this.tags.add(ctag)));
        }
        if (type != null) {
            ctag.setType(type);
        }
        return ctag;
    }

    public CTag appendCode(String id, String data) {
        return this.insert(TagType.STANDALONE, null, id, data, -1, false, false);
    }

    public CTag openCodeSpan(String id, String data) {
        return this.insert(TagType.OPENING, null, id, data, -1, false, false);
    }

    public CTag closeCodeSpan(String id, String data) {
        return this.insert(TagType.CLOSING, null, id, data, -1, true, false);
    }

    private class ContentIterable<T>
    implements Iterable<T> {
        private final Class<T> theClass;

        public ContentIterable(Class<T> theClass) {
            this.theClass = theClass;
        }

        @Override
        public Iterator<T> iterator() {
            return new ContentIterator<T>(this.theClass);
        }
    }

    private class ContentIterator<T>
    implements Iterator<T> {
        private final int mode;
        private int start;
        private int pos;
        private int returnType;

        public ContentIterator(Class<T> typeClass) {
            String typeName = typeClass.getName();
            if (typeName.equals(Object.class.getName())) {
                this.mode = 0;
            } else if (typeName.equals(String.class.getName())) {
                this.mode = 1;
            } else if (typeName.equals(Tag.class.getName())) {
                this.mode = 2;
            } else if (typeName.equals(CTag.class.getName())) {
                this.mode = 3;
            } else if (typeName.equals(MTag.class.getName())) {
                this.mode = 4;
            } else if (typeName.equals(PCont.class.getName())) {
                this.mode = 5;
            } else {
                throw new InvalidParameterException("Unsupported iteration type.");
            }
            this.pos = 0;
            this.start = 0;
            this.returnType = -1;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.returnType != -1;
        }

        @Override
        public T next() {
            int posNow = this.pos;
            int startNow = this.start;
            switch (this.returnType) {
                case 0: {
                    this.findNext();
                    return (T)Fragment.this.ctext.substring(startNow, posNow);
                }
                case 1: {
                    this.pos += 2;
                    this.findNext();
                    return (T)Fragment.this.tags.get(Fragment.this.ctext, posNow);
                }
                case 2: {
                    this.pos += 2;
                    this.findNext();
                    return (T)Fragment.this.tags.getPCont(Fragment.this.ctext, posNow);
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The method remove() not supported.");
        }

        private void findNext() {
            this.start = this.pos;
            while (this.pos < Fragment.this.ctext.length()) {
                char ch = Fragment.this.ctext.charAt(this.pos);
                if (Fragment.isChar1(ch)) {
                    if (this.start < this.pos && this.mode <= 1) {
                        this.returnType = 0;
                        return;
                    }
                    if (this.mode == 1) {
                        ++this.pos;
                        this.start = this.pos + 1;
                    } else {
                        switch (ch) {
                            case '\ue101': 
                            case '\ue102': 
                            case '\ue103': {
                                if (this.mode != 0 && this.mode != 2 && this.mode != 3) break;
                                this.returnType = 1;
                                return;
                            }
                            case '\ue104': 
                            case '\ue105': {
                                if (this.mode != 0 && this.mode != 2 && this.mode != 4) break;
                                this.returnType = 1;
                                return;
                            }
                            case '\ue106': {
                                if (this.mode != 0 && this.mode != 5) break;
                                this.returnType = 2;
                                return;
                            }
                        }
                    }
                }
                ++this.pos;
            }
            if (this.mode <= 1) {
                this.pos = Fragment.this.ctext.length();
                this.returnType = this.start < this.pos ? 0 : -1;
            } else {
                this.returnType = -1;
            }
        }
    }
}

