/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.glossary;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.ExtElements;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithExtElements;
import net.sf.okapi.lib.xliff2.glossary.Definition;
import net.sf.okapi.lib.xliff2.glossary.Term;
import net.sf.okapi.lib.xliff2.glossary.Translation;

public class GlossEntry
implements IWithExtAttributes,
IWithExtElements,
Iterable<Translation> {
    private String id;
    private String ref;
    private Term term;
    private Definition definition;
    private List<Translation> translations;
    private ExtElements xelems;
    private ExtAttributes xattrs;

    public GlossEntry() {
        this.term = new Term("");
        this.translations = new ArrayList<Translation>(1);
    }

    public GlossEntry(GlossEntry original) {
        this.id = original.id;
        this.ref = original.ref;
        this.term = new Term(original.term);
        this.definition = new Definition(original.definition);
        this.translations = new ArrayList<Translation>(original.translations.size());
        for (Translation trans : original.translations) {
            this.translations.add(new Translation(trans));
        }
        if (original.hasExtAttribute()) {
            this.xattrs = new ExtAttributes(original.xattrs);
        }
        if (original.hasExtElements()) {
            this.xelems = new ExtElements(original.xelems);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Term getTerm() {
        return this.term;
    }

    public Term setTerm(Term term) {
        this.term = term;
        return this.term;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public Definition setDefinition(Definition definition) {
        this.definition = definition;
        return this.definition;
    }

    public Translation addTranslation(String text) {
        Translation trans = new Translation(text);
        this.getTranslations().add(trans);
        return trans;
    }

    @Override
    public ExtElements getExtElements() {
        if (this.xelems == null) {
            this.xelems = new ExtElements();
        }
        return this.xelems;
    }

    @Override
    public boolean hasExtElements() {
        if (this.xelems == null) {
            return false;
        }
        return !this.xelems.isEmpty();
    }

    @Override
    public ExtElements setExtElements(ExtElements elements) {
        this.xelems = elements;
        return this.getExtElements();
    }

    @Override
    public void setExtAttributes(ExtAttributes attributes) {
        this.xattrs = attributes;
    }

    @Override
    public ExtAttributes getExtAttributes() {
        if (this.xattrs == null) {
            this.xattrs = new ExtAttributes();
        }
        return this.xattrs;
    }

    @Override
    public boolean hasExtAttribute() {
        if (this.xattrs == null) {
            return false;
        }
        return !this.xattrs.isEmpty();
    }

    @Override
    public String getExtAttributeValue(String namespaceURI, String localName) {
        if (this.xattrs == null) {
            return null;
        }
        return this.xattrs.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public Iterator<Translation> iterator() {
        return this.translations.iterator();
    }

    public List<Translation> getTranslations() {
        return this.translations;
    }
}

