/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.walker.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class XliffWalkerPathSelector {
    public static final String ALL_NODES_SELECTOR = "*";
    private String nodeId;
    private NodeType nodeType;
    private List<XliffWalkerPathSelector> childrenNodes;

    public String getNodeId() {
        return this.nodeId;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public List<XliffWalkerPathSelector> getChildrenNodes() {
        return Collections.unmodifiableList(this.childrenNodes);
    }

    public static enum NodeType {
        FILE,
        UNIT,
        SEGMENT;

    }

    public static class Builder {
        Map<String, Map<String, List<String>>> selectorMap = new LinkedHashMap<String, Map<String, List<String>>>();

        public Builder allPaths() {
            return this.selector(XliffWalkerPathSelector.ALL_NODES_SELECTOR);
        }

        public Builder selector(String fileId) {
            return this.selector(fileId, XliffWalkerPathSelector.ALL_NODES_SELECTOR);
        }

        public Builder selector(String fileId, String unitId) {
            return this.selector(fileId, unitId, XliffWalkerPathSelector.ALL_NODES_SELECTOR);
        }

        public Builder selector(String fileId, String unitId, Integer segmentIndex) {
            return this.selector(fileId, unitId, String.valueOf(segmentIndex));
        }

        private Builder selector(String fileId, String unitId, String segmentIndex) {
            this.selectorMap.computeIfAbsent(fileId, k -> new LinkedHashMap());
            this.selectorMap.get(fileId).computeIfAbsent(unitId, k -> new ArrayList());
            this.selectorMap.get(fileId).get(unitId).add(segmentIndex);
            return this;
        }

        public XliffWalkerPathSelector[] build() {
            ArrayList<XliffWalkerPathSelector> fileSelectorList = new ArrayList<XliffWalkerPathSelector>();
            for (String fileId : this.selectorMap.keySet()) {
                XliffWalkerPathSelector fileIdPathSelector = new XliffWalkerPathSelector();
                fileIdPathSelector.nodeId = fileId;
                fileIdPathSelector.nodeType = NodeType.FILE;
                fileIdPathSelector.childrenNodes = new ArrayList<XliffWalkerPathSelector>();
                for (String unitId : this.selectorMap.get(fileId).keySet()) {
                    XliffWalkerPathSelector unitIdPathSelector = new XliffWalkerPathSelector();
                    unitIdPathSelector.nodeId = unitId;
                    unitIdPathSelector.nodeType = NodeType.UNIT;
                    unitIdPathSelector.childrenNodes = new ArrayList<XliffWalkerPathSelector>();
                    for (String segmentIndex : this.selectorMap.get(fileId).get(unitId)) {
                        XliffWalkerPathSelector segmentIndexPathSelector = new XliffWalkerPathSelector();
                        segmentIndexPathSelector.nodeId = segmentIndex;
                        segmentIndexPathSelector.nodeType = NodeType.SEGMENT;
                        unitIdPathSelector.childrenNodes.add(segmentIndexPathSelector);
                    }
                    fileIdPathSelector.childrenNodes.add(unitIdPathSelector);
                }
                fileSelectorList.add(fileIdPathSelector);
            }
            return fileSelectorList.toArray(new XliffWalkerPathSelector[0]);
        }
    }
}

