/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.cleanup;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.cleanup.Cleaner;
import net.sf.okapi.steps.cleanup.Parameters;

@UsingParameters(value=Parameters.class)
public class CleanupStep
extends BasePipelineStep {
    private Cleaner cleaner = new Cleaner();
    private LocaleId sourceLocale;
    private LocaleId targetLocale;

    @Override
    public String getName() {
        return "Cleanup";
    }

    @Override
    public String getDescription() {
        return "Cleans strings by normalizing quotes, punctuation, etc. ready for further processing. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public Parameters getParameters() {
        return this.cleaner.getParameters();
    }

    @Override
    public void setParameters(IParameters params) {
        this.cleaner.setParameters((Parameters)params);
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (this.cleaner.run(tu, this.targetLocale)) {
            return Event.createNoopEvent();
        }
        return event;
    }
}

