/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.codesimplifier;

import java.util.Optional;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements ISimplifierRulesParameters,
IEditorDescriptionProvider {
    static final boolean DEFAULT_MOVE_LEADING_AND_TRAILING_CODES_TO_SKELETON = true;
    static final boolean DEFAULT_MERGE_ADJACENT_CODES = true;
    private static final String REMOVE_LEADING_TRAILING_CODES = "removeLeadingTrailingCodes";
    private static final String MERGE_CODES = "mergeCodes";
    private static final String RULES = "rules";

    @Override
    public void reset() {
        super.reset();
        this.setMoveLeadingAndTrailingCodesToSkeleton(true);
        this.setMergeAdjacentCodes(true);
        this.setSimplifierRules(null);
    }

    @Deprecated
    public boolean getRemoveLeadingTrailingCodes() {
        return this.getBoolean(REMOVE_LEADING_TRAILING_CODES);
    }

    @Override
    public Optional<Boolean> getMoveLeadingAndTrailingCodesToSkeleton() {
        return Optional.of(this.getRemoveLeadingTrailingCodes());
    }

    @Deprecated
    public void setRemoveLeadingTrailingCodes(boolean value) {
        this.setBoolean(REMOVE_LEADING_TRAILING_CODES, value);
    }

    public void setMoveLeadingAndTrailingCodesToSkeleton(boolean value) {
        this.setRemoveLeadingTrailingCodes(value);
    }

    @Deprecated
    public boolean getMergeCodes() {
        return this.getBoolean(MERGE_CODES);
    }

    @Override
    public Optional<Boolean> getMergeAdjacentCodes() {
        return Optional.of(this.getMergeCodes());
    }

    @Deprecated
    public void setMergeCodes(boolean value) {
        this.setBoolean(MERGE_CODES, value);
    }

    public void setMergeAdjacentCodes(boolean value) {
        this.setMergeCodes(value);
    }

    @Deprecated
    public String getRules() {
        return this.getString(RULES);
    }

    @Override
    public String getSimplifierRules() {
        return this.getRules();
    }

    @Deprecated
    public void setRules(String rules) {
        this.setString(RULES, rules);
    }

    @Override
    public void setSimplifierRules(String value) {
        this.setRules(value);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
    }

    private void performMigrationFor(String string) {
        if (this.available(REMOVE_LEADING_TRAILING_CODES)) {
            if (!string.contains("moveLeadingAndTrailingCodesToSkeleton")) {
                this.setMoveLeadingAndTrailingCodesToSkeleton(this.getBoolean(REMOVE_LEADING_TRAILING_CODES));
            }
            this.remove(REMOVE_LEADING_TRAILING_CODES);
        }
        if (this.available(MERGE_CODES)) {
            if (!string.contains("mergeAdjacentCodes")) {
                this.setMergeAdjacentCodes(this.getBoolean(MERGE_CODES));
            }
            this.remove(MERGE_CODES);
        }
        if (this.available(RULES)) {
            if (!string.contains("simplifierRules")) {
                this.setSimplifierRules(this.getString(RULES));
            }
            this.remove(RULES);
        }
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(REMOVE_LEADING_TRAILING_CODES, "Move leading and trailing codes to skeleton", "Moves leading and trailing codes from the source and place them in the skeleton.");
        desc.add(MERGE_CODES, "Merge adjacent codes", "Merges adjacent codes.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Inline Codes Simplifier", true, false);
        desc.addCheckboxPart(paramsDesc.get(REMOVE_LEADING_TRAILING_CODES));
        desc.addCheckboxPart(paramsDesc.get(MERGE_CODES));
        return desc;
    }
}

