/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.diffleverage;

import java.util.Comparator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.search.lucene.analysis.NgramAnalyzer;
import net.sf.okapi.lib.search.lucene.scorer.Util;
import org.apache.lucene.analysis.Analyzer;

public class FuzzyTextUnitComparator
implements Comparator<ITextUnit> {
    private static final int NGRAM_SIZE = 3;
    private boolean codeSensitive;
    private int threshold;
    private final Analyzer analyzer = new NgramAnalyzer(3);

    public FuzzyTextUnitComparator(boolean codeSensitive, int threshold, LocaleId localeId) {
        this.codeSensitive = codeSensitive;
        this.setThreshold(threshold);
    }

    public void setCodeSensitive(boolean codeSensitive) {
        this.codeSensitive = codeSensitive;
    }

    public boolean isCodeSensitive() {
        return this.codeSensitive;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public float getThreshold() {
        return this.threshold;
    }

    @Override
    public int compare(ITextUnit oldTextUnit, ITextUnit newTextUnit) {
        if (oldTextUnit.isReferent() && !newTextUnit.isReferent()) {
            return -1;
        }
        if (!oldTextUnit.isReferent() && newTextUnit.isReferent()) {
            return 1;
        }
        int result = oldTextUnit.getSource().compareTo(newTextUnit.getSource(), this.codeSensitive ? TextFragment.CompareMode.CODE_DATA_ONLY : TextFragment.CompareMode.IGNORE_CODE);
        if (result == 0) {
            return result;
        }
        return this.fuzzyCompare(oldTextUnit, newTextUnit, result);
    }

    private int fuzzyCompare(ITextUnit oldSource, ITextUnit newSource, int exactCompareResult) {
        float score = Util.calculateNgramDiceCoefficient(oldSource.getSource().getUnSegmentedContentCopy().getText(), newSource.getSource().getUnSegmentedContentCopy().getText(), this.analyzer);
        if (score >= (float)this.threshold) {
            return 0;
        }
        return exactCompareResult;
    }
}

