/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.moses;

import java.io.File;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.filters.mosestext.FilterWriterParameters;
import net.sf.okapi.filters.mosestext.MosesTextFilterWriter;

@UsingParameters(value=FilterWriterParameters.class)
public class ExtractionStep
extends BasePipelineStep {
    private LocaleId targetLocale;
    private URI inputURI;
    private URI outputURI;
    private MosesTextFilterWriter writer;
    private FilterWriterParameters params = new FilterWriterParameters();

    @Override
    public String getDescription() {
        return "Creates a Moses InlineText file from the input document. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Moses InlineText Extraction";
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_URI)
    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @Override
    public FilterWriterParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (FilterWriterParameters)params;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.writer = new MosesTextFilterWriter();
                this.writer.setOptions(this.targetLocale, "UTF-8");
                if (this.outputURI == null) {
                    File f = new File(this.inputURI.getPath() + "." + event.getStartDocument().getLocale().toString());
                    this.outputURI = f.toURI();
                }
                this.writer.setOutput(this.outputURI.getPath());
                this.writer.setParameters(this.params);
                return this.writer.handleEvent(event);
            }
            case END_DOCUMENT: {
                if (this.writer != null) {
                    event = this.writer.handleEvent(event);
                    this.writer.close();
                }
                return event;
            }
        }
        if (this.writer != null) {
            return this.writer.handleEvent(event);
        }
        return event;
    }
}

