/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import java.io.File;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Res;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class Dialogs {
    public static String[] browseFilenames(Shell parent, String title, boolean allowMultiple, String root, String filterNames, String filterExtensions) {
        FileDialog dlg = new FileDialog(parent, 0x1000 | (allowMultiple ? 2 : 0));
        dlg.setFilterPath(root);
        if (filterNames != null) {
            String[] aNames = filterNames.split("\t", -2);
            dlg.setFilterNames(aNames);
        }
        if (filterExtensions != null) {
            String[] aExts = filterExtensions.split("\t", -2);
            dlg.setFilterExtensions(aExts);
        }
        dlg.setText(title);
        if (dlg.open() == null) {
            return null;
        }
        String[] aPaths = dlg.getFileNames();
        if (!Util.isEmpty((String)dlg.getFilterPath())) {
            for (int i = 0; i < aPaths.length; ++i) {
                aPaths[i] = dlg.getFilterPath() + File.separator + aPaths[i];
            }
        }
        return aPaths;
    }

    public static String browseFilenamesForSave(Shell parent, String title, String root, String fileName, String filterNames, String filterExtensions) {
        String path;
        block6: {
            int result;
            String[] aExts = null;
            String[] aNames = null;
            if (filterExtensions != null) {
                aExts = filterExtensions.split("\t", -2);
            }
            if (filterNames != null) {
                aNames = filterNames.split("\t", -2);
            }
            path = null;
            do {
                FileDialog dlg = new FileDialog(parent, 8192);
                dlg.setFilterPath(root);
                dlg.setFileName(fileName);
                if (filterNames != null) {
                    dlg.setFilterNames(aNames);
                }
                if (filterExtensions != null) {
                    dlg.setFilterExtensions(aExts);
                }
                dlg.setText(title);
                path = dlg.open();
                if (path == null) {
                    return null;
                }
                File file = new File(path);
                if (!file.exists()) break block6;
                MessageBox mb = new MessageBox(dlg.getParent(), 456);
                mb.setText(title);
                mb.setMessage(path + Res.getString("dialogs.browseForSave"));
                result = mb.open();
                if (result != 64) continue;
                return path;
            } while (result != 256);
            return null;
        }
        return path;
    }

    public static void centerWindow(Shell target, Shell centerOn) {
        Rectangle parentRect;
        Rectangle winRect = target.getBounds();
        if (centerOn == null) {
            Monitor monitor = target.getDisplay().getPrimaryMonitor();
            parentRect = monitor.getClientArea();
        } else {
            parentRect = centerOn.getBounds();
        }
        int x = parentRect.x + (parentRect.width - winRect.width) / 2;
        int y = parentRect.y + (parentRect.height - winRect.height) / 2;
        target.setLocation(x < 0 ? 0 : x, y < 0 ? 0 : y);
    }

    public static void placeWindowInSECorner(Shell target, Shell parent) {
        Rectangle parentRect;
        Rectangle winRect = target.getBounds();
        if (parent == null) {
            Monitor monitor = target.getDisplay().getPrimaryMonitor();
            parentRect = monitor.getClientArea();
        } else {
            parentRect = parent.getBounds();
        }
        int x = parentRect.x + (parentRect.width - winRect.width);
        int y = parentRect.y + (parentRect.height - winRect.height);
        target.setLocation(x < 0 ? 0 : x, y < 0 ? 0 : y);
    }

    public static void showError(Shell shell, String message, String details) {
        MessageBox dlg = new MessageBox(shell, 1);
        dlg.setMessage(message == null ? "The error message is null." : message);
        dlg.setText(Res.getString("dialogs.errorCaption"));
        dlg.open();
    }

    public static void showWarning(Shell shell, String message, String details) {
        MessageBox dlg = new MessageBox(shell, 8);
        dlg.setMessage(message == null ? "The warning is null." : message);
        dlg.setText(Res.getString("dialogs.warningCaption"));
        dlg.open();
    }
}

