/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class MRUList {
    private LinkedList<String> list;
    private int max;

    public MRUList(int maxInList) {
        if (this.max < 2) {
            this.max = 2;
        }
        this.max = maxInList;
        this.list = new LinkedList();
    }

    public void getFromProperties(Properties properties) {
        this.list = new LinkedList();
        String tmp = properties.getProperty("mru.count");
        if (tmp == null) {
            return;
        }
        int count = Integer.valueOf(tmp);
        for (int i = 0; i < count; ++i) {
            tmp = properties.getProperty(String.format("mru.path%d", i + 1));
            if (tmp == null) continue;
            this.list.add(tmp);
        }
    }

    public void copyToProperties(Properties properties) {
        String tmp = properties.getProperty("mru.count");
        if (tmp != null) {
            properties.remove("mru.count");
            int count = Integer.valueOf(tmp);
            for (int i = 0; i < count; ++i) {
                properties.remove(String.format("mru.path%d", i + 1));
            }
        }
        properties.setProperty("mru.count", String.format("%d", this.list.size()));
        for (int i = 0; i < this.list.size(); ++i) {
            properties.setProperty(String.format("mru.path%d", i + 1), this.list.get(i));
        }
    }

    public void clear() {
        this.list = new LinkedList();
    }

    public void remove(String path) {
        this.list.remove(path);
    }

    public void add(String path) {
        int n = -1;
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get(i).equals(path)) continue;
            n = i;
            break;
        }
        if (n > -1) {
            if (n == 0) {
                return;
            }
            this.list.remove(n);
        }
        this.list.addFirst(path);
        if (this.list.size() > this.max) {
            this.list.removeLast();
        }
    }

    public String getfirst() {
        if (!this.list.isEmpty()) {
            return this.list.getFirst();
        }
        return null;
    }

    public Iterator<String> getIterator() {
        return this.list.iterator();
    }
}

