/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.ui.OKCancelPanel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

interface ResponsiveTableDialog {
    public String[] open();

    public static final class Default
    implements ResponsiveTableDialog {
        private final Shell shell;
        private final String title;
        private final String[] inputLabels;
        private final String[] inputValues;
        private List<Text> inputs;
        private String[] outputValues;

        Default(Shell shell, String title, String[] inputLabels, String[] inputValues) {
            this.shell = shell;
            this.title = title;
            this.inputLabels = inputLabels;
            this.inputValues = inputValues;
        }

        @Override
        public String[] open() {
            this.shell.setText(this.title);
            this.shell.setLayout((Layout)new GridLayout());
            this.configureInputs();
            this.configureActions();
            this.configureGeneralListeners();
            this.shell.pack();
            this.shell.open();
            Display display = this.shell.getShell().getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return this.outputValues;
        }

        private void configureInputs() {
            this.inputs = new ArrayList<Text>(this.inputLabels.length);
            for (int i = 0; i < this.inputLabels.length; ++i) {
                Label l = new Label((Composite)this.shell, 0);
                l.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
                l.setText(this.inputLabels[i]);
                Text t = new Text((Composite)this.shell, 2048);
                t.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
                this.inputs.add(t);
                if (this.inputValues.length != this.inputLabels.length) continue;
                t.setText(this.inputValues[i]);
            }
        }

        private void configureActions() {
            SelectionAdapter actionsHandler = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    outputValues = "o".equals(e.widget.getData()) ? (String[])inputs.stream().map(t -> t.getText()).toArray(String[]::new) : new String[0];
                    shell.close();
                }
            };
            OKCancelPanel actionsPanel = new OKCancelPanel((Composite)this.shell, 0, actionsHandler, false);
            GridData gd = new GridData(768);
            actionsPanel.setLayoutData(gd);
            this.shell.setDefaultButton(actionsPanel.btOK);
        }

        private void configureGeneralListeners() {
            this.shell.addListener(31, event -> {
                if (event.detail == 2) {
                    this.outputValues = new String[0];
                    this.shell.close();
                }
            });
        }
    }
}

