/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import net.sf.okapi.common.ui.Dialogs;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TextAndBrowsePanel
extends Composite {
    private Text edText;
    private Button btBrowse;
    private boolean isFolder = false;
    private boolean saveAs = false;
    private String title;
    private String filterNames;
    private String filterExtensions;

    public TextAndBrowsePanel(Composite parent, int flags, boolean isFolder, String buttonLabel) {
        super(parent, flags);
        this.createContent(isFolder, buttonLabel);
    }

    public TextAndBrowsePanel(Composite parent, int flags, boolean isFolder) {
        super(parent, flags);
        this.createContent(isFolder, null);
    }

    private void createContent(boolean browseFolder, String buttonLabel) {
        this.isFolder = browseFolder;
        this.title = "Select a File";
        GridLayout layTmp = new GridLayout(2, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        this.setLayout((Layout)layTmp);
        GridData gdTmp = new GridData(768);
        this.setLayoutData(gdTmp);
        this.edText = new Text((Composite)this, 2048);
        this.edText.setLayoutData((Object)new GridData(768));
        this.btBrowse = new Button((Composite)this, 8);
        if (buttonLabel == null) {
            this.btBrowse.setText("...");
        } else {
            this.btBrowse.setText(buttonLabel);
        }
        this.btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextAndBrowsePanel.this.isFolder) {
                    TextAndBrowsePanel.this.browseFolder();
                } else {
                    TextAndBrowsePanel.this.browsePath();
                }
            }
        });
    }

    public String getText() {
        return this.edText.getText();
    }

    public void setText(String text) {
        this.edText.setText(text);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.edText.setEnabled(enabled);
        this.btBrowse.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.edText.setEditable(editable);
        this.btBrowse.setEnabled(editable);
    }

    public boolean isSaveAs() {
        return this.saveAs;
    }

    public void setSaveAs(boolean saveAs) {
        this.saveAs = saveAs;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBrowseFilters(String filterNames, String filterExtensions) {
        this.filterNames = filterNames;
        this.filterExtensions = filterExtensions;
    }

    private void browseFolder() {
        try {
            DirectoryDialog dlg = new DirectoryDialog(this.getShell());
            dlg.setMessage("Please, select a folder.");
            dlg.setFilterPath(this.edText.getText());
            dlg.setText(this.title);
            String dir = dlg.open();
            if (dir == null) {
                return;
            }
            this.edText.setText(dir);
            this.edText.selectAll();
            this.edText.setFocus();
        }
        catch (Throwable e) {
            Dialogs.showError(this.getShell(), e.getLocalizedMessage(), null);
        }
    }

    private void browsePath() {
        try {
            if (this.saveAs) {
                String path = Dialogs.browseFilenamesForSave(this.getShell(), this.title, null, null, this.filterNames, this.filterExtensions);
                if (path == null) {
                    return;
                }
                this.edText.setText(path);
            } else {
                String[] paths = Dialogs.browseFilenames(this.getShell(), this.title, false, null, this.filterNames, this.filterExtensions);
                if (paths == null) {
                    return;
                }
                this.edText.setText(paths[0]);
            }
            this.edText.selectAll();
            this.edText.setFocus();
        }
        catch (Throwable e) {
            Dialogs.showError(this.getShell(), e.getLocalizedMessage(), null);
        }
    }
}

