/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.filters;

import java.io.File;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.ui.ClosePanel;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.InputDialog;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.filters.FilterConfigurationsPanel;
import net.sf.okapi.common.ui.filters.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FilterConfigurationsDialog {
    private Shell shell;
    private FilterConfigurationsPanel pnlConfigs;
    private FilterConfigurationMapper mapper;
    private String result = null;
    private IHelp help;
    private Text edParamsFolder;
    private Button btGetParamsFolder;

    public FilterConfigurationsDialog(Shell parent, boolean selectionMode, FilterConfigurationMapper mapper, IHelp helpParam) {
        this.mapper = mapper;
        this.help = helpParam;
        this.shell = new Shell(parent, 65648);
        this.shell.setText(Res.getString("FilterConfigurationsDialog.caption"));
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout((Layout)new GridLayout());
        this.pnlConfigs = new FilterConfigurationsPanel((Composite)this.shell, 0, "net.sf.okapi.common.ui.filters.FilterConfigurationIdentifierEditor", (IFilterConfigurationMapper)mapper);
        GridData gdTmp = new GridData(1808);
        this.pnlConfigs.setLayoutData(gdTmp);
        Group group = new Group((Composite)this.shell, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(Res.getString("FilterConfigurationsDialog.customConfigCaption"));
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(Res.getString("FilterConfigurationsDialog.folder"));
        this.edParamsFolder = new Text((Composite)group, 2048);
        this.edParamsFolder.setLayoutData((Object)new GridData(768));
        this.edParamsFolder.setEditable(false);
        this.btGetParamsFolder = new Button((Composite)group, 8);
        this.btGetParamsFolder.setText("...");
        this.btGetParamsFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FilterConfigurationsDialog.this.editParamsFolder();
            }
        });
        this.edParamsFolder.setText(mapper.getCustomConfigurationsDirectory());
        SelectionAdapter Actions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConfigurationsDialog.this.result = null;
                if (e.widget.getData().equals("h")) {
                    if (FilterConfigurationsDialog.this.help != null) {
                        FilterConfigurationsDialog.this.help.showWiki("Filter Configurations");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    FilterConfigurationsDialog.this.result = FilterConfigurationsDialog.this.pnlConfigs.getConfigurationId();
                }
                FilterConfigurationsDialog.this.shell.close();
            }
        };
        if (selectionMode) {
            pnlActions = new OKCancelPanel((Composite)this.shell, 0, Actions, this.help != null, Res.getString("FilterConfigurationsDialog.select"));
            gdTmp = new GridData(768);
            gdTmp.horizontalSpan = 2;
            pnlActions.setLayoutData((Object)gdTmp);
            this.shell.setDefaultButton(pnlActions.btOK);
        } else {
            pnlActions = new ClosePanel((Composite)this.shell, 0, Actions, this.help != null);
            gdTmp = new GridData(768);
            gdTmp.horizontalSpan = 2;
            pnlActions.setLayoutData((Object)gdTmp);
            this.shell.setDefaultButton(pnlActions.btClose);
        }
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 760) {
            startSize.x = 760;
        }
        if (startSize.y < 550) {
            startSize.y = 550;
        }
        this.shell.setSize(startSize);
        Dialogs.centerWindow(this.shell, parent);
    }

    private void editParamsFolder() {
        try {
            InputDialog dlg = new InputDialog(this.shell, Res.getString("FilterConfigurationsDialog.customConfigCaption"), Res.getString("FilterConfigurationsDialog.customConfigCaptionLabel"), this.edParamsFolder.getText(), null, 1, -1, -1);
            dlg.setAllowEmptyValue(false);
            Object newDir = dlg.showDialog();
            if (newDir == null) {
                return;
            }
            if (!((String)newDir).endsWith(File.separator)) {
                newDir = (String)newDir + File.separator;
            }
            this.edParamsFolder.setText((String)newDir);
            this.updateCustomConfigurations();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    public String showDialog(String configId) {
        this.pnlConfigs.setConfiguration(configId);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    public void updateCustomConfigurations() {
        this.mapper.setCustomConfigurationsDirectory(this.edParamsFolder.getText());
        this.mapper.updateCustomConfigurations();
        this.pnlConfigs.updateData();
    }
}

