/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.filters;

import net.sf.okapi.common.BaseContext;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.exceptions.OkapiEditorCreationException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.ui.BaseHelp;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.filters.FilterConfigurationEditor;
import net.sf.okapi.common.ui.filters.FilterConfigurationInfoEditor;
import net.sf.okapi.common.ui.filters.FilterConfigurationsTableModel;
import net.sf.okapi.common.ui.filters.IFilterConfigurationInfoEditor;
import net.sf.okapi.common.ui.filters.Res;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class FilterConfigurationsPanel
extends Composite {
    private Table table;
    private FilterConfigurationsTableModel model;
    private Text edFilter;
    private Text edDescription;
    private Button btEdit;
    private Button btCreate;
    private Button btDelete;
    private IFilterConfigurationMapper mapper;
    private IFilter cachedFilter;
    private IContext context;
    private String configEditorClass;

    public FilterConfigurationsPanel(Composite parent, int style, String filterConfigInfoDialogClass, IFilterConfigurationMapper mapper) {
        super(parent, style);
        this.createContent();
        this.configEditorClass = filterConfigInfoDialogClass;
        this.mapper = mapper;
        this.model.setMapper(mapper);
        this.context = new BaseContext();
        this.context.setObject("shell", (Object)this.getShell());
        this.context.setObject("help", (Object)new BaseHelp("."));
    }

    public void setConfiguration(String configId) {
        this.model.updateTable(0, configId);
        this.updateInfo();
    }

    public void updateData() {
        int n = this.table.getSelectionIndex();
        String configId = null;
        if (n > -1) {
            configId = this.table.getItem(n).getText(1);
        }
        this.model.updateTable(0, configId);
        this.updateInfo();
    }

    public String getConfigurationId() {
        int n = this.table.getSelectionIndex();
        if (n == -1) {
            return null;
        }
        return this.table.getItem(n).getText(1);
    }

    private void createContent() {
        GridLayout layTmp = new GridLayout(3, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        this.setLayout((Layout)layTmp);
        this.table = new Table((Composite)this, 67588);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 3;
        this.table.setLayoutData((Object)gdTmp);
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle rect = FilterConfigurationsPanel.this.table.getClientArea();
                int whidthCol3 = 80;
                int nPart = (rect.width - whidthCol3) / 100;
                int remainder = (rect.width - whidthCol3) % 100;
                FilterConfigurationsPanel.this.table.getColumn(0).setWidth(38 * nPart + remainder - 1);
                FilterConfigurationsPanel.this.table.getColumn(1).setWidth(36 * nPart);
                FilterConfigurationsPanel.this.table.getColumn(2).setWidth(26 * nPart);
                FilterConfigurationsPanel.this.table.getColumn(3).setWidth(whidthCol3);
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                FilterConfigurationsPanel.this.editParameters();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConfigurationsPanel.this.updateInfo();
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ') {
                    FilterConfigurationsPanel.this.editParameters();
                } else if (e.keyCode == 127) {
                    FilterConfigurationsPanel.this.deleteConfiguration();
                }
            }
        });
        this.model = new FilterConfigurationsTableModel();
        this.model.linkTable(this.table);
        this.edFilter = new Text((Composite)this, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 3;
        this.edFilter.setLayoutData((Object)gdTmp);
        this.edFilter.setEditable(false);
        this.edDescription = new Text((Composite)this, 2368);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 3;
        gdTmp.heightHint = 40;
        this.edDescription.setLayoutData((Object)gdTmp);
        this.edDescription.setEditable(false);
        this.btEdit = new Button((Composite)this, 8);
        this.btEdit.setText(Res.getString("FilterConfigurationsPanel.edit"));
        this.btEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConfigurationsPanel.this.editParameters();
            }
        });
        this.btCreate = new Button((Composite)this, 8);
        this.btCreate.setText(Res.getString("FilterConfigurationsPanel.create"));
        this.btCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConfigurationsPanel.this.createConfiguration();
            }
        });
        this.btDelete = new Button((Composite)this, 8);
        this.btDelete.setText(Res.getString("FilterConfigurationsPanel.delete"));
        this.btDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConfigurationsPanel.this.deleteConfiguration();
            }
        });
        int nWidth = UIUtil.getMinimumWidth(80, this.btEdit, Res.getString("FilterConfigurationsPanel.view"));
        UIUtil.setSameWidth(nWidth, new Control[]{this.btEdit, this.btCreate, this.btDelete});
    }

    private void updateInfo() {
        FilterConfiguration config;
        int n = this.table.getSelectionIndex();
        if (n > -1 && (config = this.mapper.getConfiguration(this.table.getItem(n).getText(1))) != null) {
            this.edFilter.setText(config.filterClass);
            this.edDescription.setText(config.description);
            this.btEdit.setEnabled(true);
            if (config.custom) {
                this.btEdit.setText(Res.getString("FilterConfigurationsPanel.edit"));
            } else {
                this.btEdit.setText(Res.getString("FilterConfigurationsPanel.view"));
            }
            this.btDelete.setEnabled(config.custom);
            this.btCreate.setEnabled(true);
            return;
        }
        this.edFilter.setText("");
        this.edDescription.setText("");
        this.btEdit.setEnabled(false);
        this.btCreate.setEnabled(false);
        this.btDelete.setEnabled(false);
    }

    private void editParameters() {
        try {
            int n = this.table.getSelectionIndex();
            if (n == -1) {
                return;
            }
            FilterConfiguration config = this.mapper.getConfiguration(this.table.getItem(n).getText(1));
            if (config == null) {
                return;
            }
            this.cachedFilter = this.mapper.createFilter(config.configId, this.cachedFilter);
            FilterConfigurationEditor editor = new FilterConfigurationEditor();
            editor.editConfiguration(config.configId, this.mapper, this.cachedFilter, this.getShell(), this.context);
        }
        catch (Throwable e) {
            Dialogs.showError(this.getShell(), e.getMessage(), null);
        }
    }

    private void deleteConfiguration() {
        try {
            int n = this.table.getSelectionIndex();
            if (n == -1) {
                return;
            }
            String id = this.table.getItem(n).getText(1);
            FilterConfiguration config = this.mapper.getConfiguration(id);
            if (!config.custom) {
                return;
            }
            MessageBox dlg = new MessageBox(this.getParent().getShell(), 452);
            dlg.setMessage(String.format(Res.getString("FilterConfigurationsPanel.confirmDeletion"), id));
            dlg.setText("Rainbow");
            switch (dlg.open()) {
                case 128: 
                case 256: {
                    return;
                }
            }
            this.mapper.deleteCustomParameters(config);
            this.mapper.removeConfiguration(id);
            this.model.updateTable(n, null);
            this.updateInfo();
        }
        catch (Throwable e) {
            Dialogs.showError(this.getShell(), e.getMessage(), null);
        }
    }

    private void createConfiguration() {
        try {
            int n = this.table.getSelectionIndex();
            if (n == -1) {
                return;
            }
            FilterConfiguration baseConfig = this.mapper.getConfiguration(this.table.getItem(n).getText(1));
            if (baseConfig == null) {
                return;
            }
            FilterConfiguration newConfig = this.mapper.createCustomConfiguration(baseConfig);
            if (newConfig == null) {
                MessageBox dlg = new MessageBox(this.getShell(), 2);
                dlg.setMessage("This filter has no parameters.");
                dlg.setText("Information");
                dlg.open();
                return;
            }
            if (!this.editConfigurationInfo(newConfig)) {
                return;
            }
            IParameters newParams = this.mapper.getParameters(baseConfig);
            this.mapper.saveCustomParameters(newConfig, newParams);
            this.mapper.addConfiguration(newConfig);
            this.model.updateTable(0, newConfig.configId);
            this.updateInfo();
            this.editParameters();
        }
        catch (Throwable e) {
            Dialogs.showError(this.getShell(), e.getMessage(), null);
        }
    }

    private boolean editConfigurationInfo(FilterConfiguration config) {
        IFilterConfigurationInfoEditor editor;
        if (this.configEditorClass == null) {
            editor = new FilterConfigurationInfoEditor();
        } else {
            try {
                editor = (IFilterConfigurationInfoEditor)Class.forName(this.configEditorClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new OkapiEditorCreationException(String.format(Res.getString("FilterConfigurationsPanel.cannotCreateEditor"), this.configEditorClass), (Throwable)e);
            }
        }
        editor.create(this.getShell());
        return editor.showDialog(config, this.mapper);
    }
}

