/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.filters;

import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.filters.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class InlineCodeFinderPanel
extends Composite {
    private static final String ACCEPT_LABEL = Res.getString("InlineCodeFinderPanel.accept");
    private InlineCodeFinder codeFinder = new InlineCodeFinder();
    private List lbRules;
    private Text edExpression;
    private Text edSample;
    private Text edResults;
    private Button btMoveUp;
    private Button btModify;
    private Button btDiscard;
    private Button btInsertPattern;
    private Button btAdd;
    private Button btRemove;
    private Button btMoveDown;
    private Button chkTestAllRules;
    private boolean editMode;
    private boolean wasNew;
    private TextFragment textFrag = new TextFragment();
    private GenericContent genericCont = new GenericContent();
    private boolean canUpdateTest = true;

    public InlineCodeFinderPanel(Composite parent, int flags) {
        super(parent, flags);
        this.createContent();
    }

    private void createContent() {
        GridLayout layTmp = new GridLayout(5, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        this.setLayout((Layout)layTmp);
        Composite cmpRules = new Composite((Composite)this, 0);
        layTmp = new GridLayout(2, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        cmpRules.setLayout((Layout)layTmp);
        GridData gdTmp = new GridData(1040);
        gdTmp.verticalSpan = 4;
        cmpRules.setLayoutData((Object)gdTmp);
        this.lbRules = new List(cmpRules, 2560);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 2;
        gdTmp.grabExcessVerticalSpace = true;
        this.lbRules.setLayoutData((Object)gdTmp);
        this.lbRules.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InlineCodeFinderPanel.this.updateDisplay();
            }
        });
        int buttonSet1Width = 90;
        int buttonSet2Width = 90;
        Composite cmpTmp = new Composite(cmpRules, 0);
        layTmp = new GridLayout(2, true);
        layTmp.marginWidth = 0;
        layTmp.marginHeight = 0;
        cmpTmp.setLayout((Layout)layTmp);
        this.btAdd = new Button(cmpTmp, 8);
        this.btAdd.setText(Res.getString("InlineCodeFinderPanel.add"));
        gdTmp = new GridData(768);
        this.btAdd.setLayoutData((Object)gdTmp);
        UIUtil.ensureWidth((Control)this.btAdd, buttonSet1Width);
        this.btAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InlineCodeFinderPanel.this.startEditMode(true);
            }
        });
        this.btMoveUp = new Button(cmpTmp, 8);
        this.btMoveUp.setText(Res.getString("InlineCodeFinderPanel.moveUp"));
        gdTmp = new GridData(768);
        this.btMoveUp.setLayoutData((Object)gdTmp);
        this.btMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InlineCodeFinderPanel.this.moveUp();
            }
        });
        this.btRemove = new Button(cmpTmp, 8);
        this.btRemove.setText(Res.getString("InlineCodeFinderPanel.remove"));
        gdTmp = new GridData(768);
        this.btRemove.setLayoutData((Object)gdTmp);
        this.btRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InlineCodeFinderPanel.this.removeExpression();
            }
        });
        this.btMoveDown = new Button(cmpTmp, 8);
        this.btMoveDown.setText(Res.getString("InlineCodeFinderPanel.moveDown"));
        gdTmp = new GridData(768);
        this.btMoveDown.setLayoutData((Object)gdTmp);
        this.btMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InlineCodeFinderPanel.this.moveDown();
            }
        });
        this.edExpression = new Text((Composite)this, 2562);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 4;
        gdTmp.heightHint = 60;
        this.edExpression.setLayoutData((Object)gdTmp);
        this.edExpression.setEditable(false);
        this.edExpression.addModifyListener(e -> this.updateTest());
        this.btModify = new Button((Composite)this, 8);
        gdTmp = new GridData();
        this.btModify.setLayoutData((Object)gdTmp);
        int max = buttonSet2Width;
        this.btModify.setText(ACCEPT_LABEL);
        this.btModify.pack();
        Rectangle rect = this.btModify.getBounds();
        if (rect.width > max) {
            max = rect.width;
        }
        this.btModify.setText(Res.getString("InlineCodeFinderPanel.modify"));
        UIUtil.ensureWidth((Control)this.btModify, max);
        this.btModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (InlineCodeFinderPanel.this.editMode) {
                    InlineCodeFinderPanel.this.endEditMode(true);
                } else {
                    InlineCodeFinderPanel.this.startEditMode(false);
                }
            }
        });
        this.btDiscard = new Button((Composite)this, 8);
        this.btDiscard.setText(Res.getString("InlineCodeFinderPanel.discard"));
        gdTmp = new GridData();
        this.btDiscard.setLayoutData((Object)gdTmp);
        UIUtil.ensureWidth((Control)this.btDiscard, buttonSet2Width);
        this.btDiscard.setEnabled(false);
        this.btDiscard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InlineCodeFinderPanel.this.endEditMode(false);
            }
        });
        this.btInsertPattern = new Button((Composite)this, 8);
        this.btInsertPattern.setText(Res.getString("InlineCodeFinderPanel.patterns"));
        gdTmp = new GridData();
        this.btInsertPattern.setLayoutData((Object)gdTmp);
        UIUtil.ensureWidth((Control)this.btInsertPattern, buttonSet2Width);
        this.btInsertPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Util.openURL((String)"https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html");
            }
        });
        this.chkTestAllRules = new Button((Composite)this, 32);
        this.chkTestAllRules.setText(Res.getString("InlineCodeFinderPanel.useAllrules"));
        gdTmp = new GridData();
        this.chkTestAllRules.setLayoutData((Object)gdTmp);
        this.chkTestAllRules.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InlineCodeFinderPanel.this.updateTest();
            }
        });
        this.edSample = new Text((Composite)this, 2562);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 4;
        gdTmp.heightHint = 60;
        this.edSample.setLayoutData((Object)gdTmp);
        this.edSample.addModifyListener(e -> this.updateTest());
        this.edResults = new Text((Composite)this, 2562);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 4;
        gdTmp.heightHint = 60;
        this.edResults.setLayoutData((Object)gdTmp);
        this.edResults.setEditable(false);
        this.updateDisplay();
    }

    private void moveUp() {
        int n = this.lbRules.getSelectionIndex();
        if (n < 1) {
            return;
        }
        String tmp = this.lbRules.getItem(n);
        this.lbRules.setItem(n, this.lbRules.getItem(n - 1));
        this.lbRules.setItem(n - 1, tmp);
        this.lbRules.select(n - 1);
        this.updateDisplay();
    }

    private void moveDown() {
        int n = this.lbRules.getSelectionIndex();
        if (n == -1) {
            return;
        }
        String tmp = this.lbRules.getItem(n);
        this.lbRules.setItem(n, this.lbRules.getItem(n + 1));
        this.lbRules.setItem(n + 1, tmp);
        this.lbRules.select(n + 1);
        this.updateDisplay();
    }

    private void startEditMode(boolean createNew) {
        try {
            int n;
            this.wasNew = createNew;
            if (createNew) {
                this.lbRules.add("");
                this.lbRules.setSelection(this.lbRules.getItemCount() - 1);
                this.canUpdateTest = false;
                this.updateDisplay();
                this.canUpdateTest = true;
            }
            if ((n = this.lbRules.getSelectionIndex()) == -1) {
                return;
            }
            this.toggleMode(true);
        }
        catch (Throwable e) {
            Dialogs.showError(this.getShell(), e.getMessage(), null);
        }
    }

    public boolean endEditMode(boolean accept) {
        if (accept) {
            if (this.edExpression.getText().length() == 0) {
                Dialogs.showError(this.getShell(), Res.getString("InlineCodeFinderPanel.enterExpression"), null);
                this.edExpression.setFocus();
                return false;
            }
            this.lbRules.setItem(this.lbRules.getSelectionIndex(), this.edExpression.getText());
        } else if (this.wasNew) {
            this.removeExpression();
        }
        this.toggleMode(false);
        return true;
    }

    private void toggleMode(boolean editMode) {
        this.editMode = editMode;
        this.lbRules.setEnabled(!editMode);
        this.edExpression.setEditable(editMode);
        this.btDiscard.setEnabled(editMode);
        this.btAdd.setEnabled(!editMode);
        if (editMode) {
            this.btRemove.setEnabled(false);
            this.btMoveUp.setEnabled(false);
            this.btMoveDown.setEnabled(false);
            this.btModify.setEnabled(true);
            this.btModify.setText(ACCEPT_LABEL);
            this.edExpression.setFocus();
        } else {
            this.btModify.setText(Res.getString("InlineCodeFinderPanel.modify"));
            this.updateDisplay();
        }
    }

    public void removeExpression() {
        int n = this.lbRules.getSelectionIndex();
        if (n == -1) {
            return;
        }
        this.lbRules.remove(n);
        if (n >= this.lbRules.getItemCount()) {
            n = this.lbRules.getItemCount() - 1;
        }
        if (n > -1) {
            this.lbRules.setSelection(n);
        }
        this.updateDisplay();
    }

    public void updateDisplay() {
        int n = this.lbRules.getSelectionIndex();
        this.btRemove.setEnabled(n > -1);
        this.btMoveUp.setEnabled(n > 0);
        this.btMoveDown.setEnabled(n < this.lbRules.getItemCount() - 1);
        this.btModify.setEnabled(n > -1);
        if (n == -1) {
            this.edExpression.setText("");
        } else {
            this.edExpression.setText(this.lbRules.getItem(n));
        }
    }

    private void updateTest() {
        if (!this.canUpdateTest) {
            return;
        }
        try {
            int n = this.lbRules.getSelectionIndex();
            if (n == -1) {
                return;
            }
            this.codeFinder.getRules().clear();
            if (this.chkTestAllRules.getSelection()) {
                for (String pattern : this.lbRules.getItems()) {
                    this.codeFinder.addRule(pattern);
                }
                this.codeFinder.getRules().set(n, this.edExpression.getText());
            } else {
                this.codeFinder.addRule(this.edExpression.getText());
            }
            this.codeFinder.compile();
            this.textFrag.clear();
            this.textFrag.setCodedText(this.getSampleText());
            this.codeFinder.process(this.textFrag);
            this.genericCont.setContent(this.textFrag);
            this.edResults.setText(this.genericCont.toString());
        }
        catch (Throwable e) {
            this.edResults.setText(e.getMessage());
        }
    }

    private String getSampleText() {
        String tmp = this.edSample.getText();
        tmp = tmp.replaceAll("\r\r\n", "\n");
        tmp = tmp.replace("\r\n", "\n");
        return tmp.replace("\r", "\n");
    }

    public void setRules(String codeFinderRules) {
        this.codeFinder.fromString(codeFinderRules);
        this.lbRules.removeAll();
        for (String pattern : this.codeFinder.getRules()) {
            this.lbRules.add(pattern);
        }
        this.edSample.setText(this.codeFinder.getSample());
        this.chkTestAllRules.setSelection(this.codeFinder.useAllRulesWhenTesting());
        if (this.lbRules.getItemCount() > 0) {
            this.lbRules.setSelection(0);
            this.updateDisplay();
        }
    }

    public String getRules() {
        if (this.editMode && !this.endEditMode(true)) {
            return null;
        }
        this.codeFinder.getRules().clear();
        for (String pattern : this.lbRules.getItems()) {
            this.codeFinder.addRule(pattern);
        }
        this.codeFinder.setSample(this.getSampleText());
        this.codeFinder.setUseAllRulesWhenTesting(this.chkTestAllRules.getSelection());
        return this.codeFinder.toString();
    }

    public boolean inEditMode() {
        return this.editMode;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.btAdd.setEnabled(enabled);
        this.chkTestAllRules.setEnabled(enabled);
        this.lbRules.setEnabled(enabled);
        this.edExpression.setEnabled(enabled);
        this.edResults.setEnabled(enabled);
        this.edSample.setEnabled(enabled);
        this.btInsertPattern.setEnabled(enabled);
        if (enabled) {
            this.updateDisplay();
        } else {
            if (this.inEditMode()) {
                this.endEditMode(false);
            }
            this.btDiscard.setEnabled(false);
            this.btRemove.setEnabled(false);
            this.btMoveUp.setEnabled(false);
            this.btMoveDown.setEnabled(false);
            this.btModify.setEnabled(false);
        }
    }
}

