/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.filters;

import net.sf.okapi.common.LocalePair;
import net.sf.okapi.common.filters.fontmappings.DefaultFontMapping;
import net.sf.okapi.common.filters.fontmappings.FontMapping;
import org.eclipse.swt.widgets.TableItem;

final class TableItemFontMapping
implements FontMapping {
    private final TableItem tableItem;
    private FontMapping defaultFontMapping;
    private boolean read;

    TableItemFontMapping(TableItem tableItem) {
        this.tableItem = tableItem;
    }

    public boolean applicableTo(LocalePair pair) {
        if (!this.read) {
            this.fromTableItem();
        }
        return this.defaultFontMapping.applicableTo(pair);
    }

    public boolean applicableTo(String sourceFont) {
        if (!this.read) {
            this.fromTableItem();
        }
        return this.defaultFontMapping.applicableTo(sourceFont);
    }

    public String targetFont() {
        if (!this.read) {
            this.fromTableItem();
        }
        return this.defaultFontMapping.targetFont();
    }

    private void fromTableItem() {
        this.defaultFontMapping = new DefaultFontMapping(this.tableItem.getText(0), this.tableItem.getText(1), this.tableItem.getText(2), this.tableItem.getText(3));
        this.read = true;
    }

    public <T> T writtenTo(FontMapping.Output<T> output) {
        if (!this.read) {
            this.fromTableItem();
        }
        return (T)this.defaultFontMapping.writtenTo(output);
    }
}

