/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.plugins;

import java.io.BufferedInputStream;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ZipUtil;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.ui.ClosePanel;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.plugins.PluginInfo;
import net.sf.okapi.common.ui.plugins.TableModel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginsManagerDialog {
    private static final int BUFFERSIZE = 5120;
    private Shell shell;
    private IHelp help;
    private Text edURL;
    private Button btRefreshURL;
    private Text edDir;
    private Button btInstall;
    private Button btRemove;
    private TableModel modAvailable;
    private Table tblAvailable;
    private Text edDescription;
    private Button btPluginHelp;
    private TableModel modCurrent;
    private Table tblCurrent;
    private URL repository;
    private File dropinsDir;
    private Label stStatus;
    private boolean actionHasBeenCalled = false;
    private ArrayList<String> lockedPlugins;

    public PluginsManagerDialog(Shell parent, IHelp helpParam, File dropinsDir, URL repository) {
        this.repository = repository;
        this.dropinsDir = dropinsDir;
        this.help = helpParam;
        this.shell = new Shell(parent, 65648);
        this.shell.setText("Plugins Manager");
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout((Layout)new GridLayout());
        int longButtonsWidth = 200;
        Group grpCurrent = new Group((Composite)this.shell, 0);
        grpCurrent.setText("Plugins Currently Installed");
        GridData gdTmp = new GridData(1808);
        grpCurrent.setLayoutData((Object)gdTmp);
        grpCurrent.setLayout((Layout)new GridLayout(2, false));
        this.tblCurrent = this.createTable(false, (Composite)grpCurrent, 2);
        this.modCurrent = new TableModel(this.tblCurrent, false);
        this.btRemove = UIUtil.createGridButton((Composite)grpCurrent, 8, "Remove Checked Plugins...", 200, 1);
        this.btRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginsManagerDialog.this.remove();
            }
        });
        this.edDir = new Text((Composite)grpCurrent, 2048);
        gdTmp = new GridData(768);
        this.edDir.setLayoutData((Object)gdTmp);
        this.edDir.setEditable(false);
        Group grpAvailable = new Group((Composite)this.shell, 0);
        grpAvailable.setText("Plugins Available for Installation");
        gdTmp = new GridData(1808);
        grpAvailable.setLayoutData((Object)gdTmp);
        grpAvailable.setLayout((Layout)new GridLayout(2, false));
        this.edURL = new Text((Composite)grpAvailable, 2048);
        gdTmp = new GridData(768);
        this.edURL.setLayoutData((Object)gdTmp);
        this.btRefreshURL = UIUtil.createGridButton((Composite)grpAvailable, 8, "Refresh", 80, 1);
        this.btRefreshURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginsManagerDialog.this.refresh();
            }
        });
        this.shell.setDefaultButton(this.btRefreshURL);
        this.tblAvailable = this.createTable(true, (Composite)grpAvailable, 2);
        this.modAvailable = new TableModel(this.tblAvailable, true);
        this.tblAvailable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PluginsManagerDialog.this.updateAvailable();
            }
        });
        Composite cmpTmp = new Composite((Composite)grpAvailable, 0);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 2;
        cmpTmp.setLayoutData((Object)gdTmp);
        GridLayout layTmp = new GridLayout(2, false);
        layTmp.marginWidth = 0;
        layTmp.marginHeight = 0;
        cmpTmp.setLayout((Layout)layTmp);
        this.btInstall = new Button(cmpTmp, 8);
        this.btInstall.setText("Install Checked Plugins...");
        gdTmp = new GridData(34);
        gdTmp.widthHint = 200;
        this.btInstall.setLayoutData((Object)gdTmp);
        this.btInstall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginsManagerDialog.this.install();
            }
        });
        this.edDescription = new Text(cmpTmp, 2112);
        gdTmp = new GridData(1808);
        gdTmp.verticalSpan = 2;
        this.edDescription.setLayoutData((Object)gdTmp);
        this.edDescription.setEditable(false);
        this.btPluginHelp = new Button(cmpTmp, 8);
        this.btPluginHelp.setText("Plugin Help");
        gdTmp = new GridData(34);
        gdTmp.widthHint = 200;
        this.btPluginHelp.setLayoutData((Object)gdTmp);
        this.btPluginHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginsManagerDialog.this.callPluginHelp();
            }
        });
        this.stStatus = new Label((Composite)this.shell, 0);
        this.stStatus.setLayoutData((Object)new GridData(64));
        SelectionAdapter CloseActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    if (PluginsManagerDialog.this.help != null) {
                        PluginsManagerDialog.this.help.showWiki("Plugins Manager");
                    }
                    return;
                }
                if (e.widget.getData().equals("c")) {
                    PluginsManagerDialog.this.shell.close();
                }
            }
        };
        ClosePanel pnlActions = new ClosePanel((Composite)this.shell, 0, CloseActions, true);
        gdTmp = new GridData(768);
        pnlActions.setLayoutData(gdTmp);
        this.shell.pack();
        Rectangle rect = this.shell.getBounds();
        this.shell.setMinimumSize(rect.width, rect.height);
        if (rect.width < 750) {
            rect.width = 750;
        }
        if (rect.height < 480) {
            rect.height = 480;
        }
        this.shell.setSize(rect.width, rect.height);
        Dialogs.centerWindow(this.shell, parent);
        this.setData();
        this.btRefreshURL.setFocus();
    }

    public boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.actionHasBeenCalled;
    }

    private void callPluginHelp() {
        String tmp = (String)this.btPluginHelp.getData();
        if (tmp == null) {
            return;
        }
        try {
            Util.openURL((String)new URL(tmp).toString());
        }
        catch (MalformedURLException e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void updateAvailable() {
        int n = this.tblAvailable.getSelectionIndex();
        String helpString = null;
        if (n == -1) {
            this.edDescription.setText("");
        } else {
            PluginInfo pi = (PluginInfo)this.tblAvailable.getItem(n).getData();
            this.edDescription.setText(pi.getDescription() == null ? "" : pi.getDescription());
            helpString = pi.getHelpURL();
        }
        this.btPluginHelp.setData(helpString);
        this.btPluginHelp.setEnabled(helpString != null);
    }

    private Table createTable(boolean maxMode, Composite parent, int horizontalSpan) {
        final Table table = new Table(parent, 67616);
        GridData gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = horizontalSpan;
        gdTmp.minimumHeight = 40;
        gdTmp.minimumWidth = 350;
        table.setLayoutData((Object)gdTmp);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        if (maxMode) {
            table.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle rect = table.getClientArea();
                    int part = rect.width / 100;
                    int remain = rect.width % 100;
                    table.getColumn(0).setWidth(remain + part * 67);
                    table.getColumn(1).setWidth(part * 33);
                }
            });
        } else {
            table.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle rect = table.getClientArea();
                    int part = rect.width / 100;
                    int remain = rect.width % 100;
                    table.getColumn(0).setWidth(remain + part * 90);
                    table.getColumn(1).setWidth(part * 10);
                }
            });
        }
        return table;
    }

    private void setStatus(String text) {
        if (text == null) {
            this.stStatus.setText("");
        } else {
            this.stStatus.setText(text);
        }
        this.shell.layout();
        Display.getCurrent().update();
    }

    private void setData() {
        String tmp = "http://okapi.opentag.com/plugins";
        if (this.repository != null) {
            tmp = this.repository.toString();
        }
        this.edURL.setText(tmp);
        this.edDir.setText(this.dropinsDir.getPath());
        List<PluginInfo> list = this.getCurrentPluginsFromDirectory();
        this.lockedPlugins = new ArrayList();
        for (PluginInfo pi : list) {
            this.lockedPlugins.add(pi.getName());
        }
        this.refreshCurrentPlugins();
        this.updateAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        try {
            this.setStatus("Refreshing lists...");
            this.refreshCurrentPlugins();
            String tmp = this.edURL.getText().trim();
            if (tmp.endsWith("/")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            this.repository = new URL(tmp);
            this.edURL.setText(tmp.toString());
            int index = this.tblAvailable.getSelectionIndex();
            URL url = new URL(String.valueOf(this.repository) + "/pluginsDeployment.xml");
            this.modAvailable.updateTable(this.loadInfoList(url), null, index);
            this.updateAvailable();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
        finally {
            this.setStatus(null);
        }
    }

    private List<PluginInfo> getCurrentPluginsFromDirectory() {
        ArrayList<PluginInfo> list = new ArrayList<PluginInfo>();
        try {
            File[] files = this.dropinsDir.listFiles();
            if (files == null) {
                throw new OkapiException(String.format("Invalid location for the installed plugins (%s)", this.dropinsDir));
            }
            for (File file : files) {
                if (!file.isDirectory()) continue;
                list.add(new PluginInfo(file.getName(), null, null, null));
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
        return list;
    }

    private void refreshCurrentPlugins() {
        try {
            int index = this.tblCurrent.getSelectionIndex();
            List<PluginInfo> list = this.getCurrentPluginsFromDirectory();
            this.modCurrent.updateTable(list, this.lockedPlugins, index);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private List<String> getCheckedItems(Table table) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < table.getItemCount(); ++i) {
            if (!table.getItem(i).getChecked()) continue;
            list.add(table.getItem(i).getText(0));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install() {
        boolean finalRefresh = false;
        try {
            List<String> list = this.getCheckedItems(this.tblAvailable);
            if (list.isEmpty()) {
                return;
            }
            MessageBox dlg = new MessageBox(this.shell, 452);
            dlg.setMessage("This command will install the plugins you have checked in the list.\nDo you want to proceed?");
            dlg.setText("Installing Plugins");
            if (dlg.open() != 64) {
                return;
            }
            this.actionHasBeenCalled = true;
            finalRefresh = true;
            for (String name : list) {
                this.installPlugin(name);
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
        finally {
            this.setStatus(null);
            if (finalRefresh) {
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        boolean finalRefresh = false;
        try {
            List<String> list = this.getCheckedItems(this.tblCurrent);
            if (list.isEmpty()) {
                return;
            }
            MessageBox dlg = new MessageBox(this.shell, 452);
            dlg.setMessage("This command will remove the unlocked plugins you have checked in the list.\nDo you want to proceed?");
            dlg.setText("Removing Plugins");
            if (dlg.open() != 64) {
                return;
            }
            this.actionHasBeenCalled = true;
            finalRefresh = true;
            for (String name : list) {
                this.removePlugin(name);
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
        finally {
            this.setStatus(null);
            if (finalRefresh) {
                this.refresh();
            }
        }
    }

    private void removePlugin(String pluginName) {
        try {
            this.setStatus(String.format("Removing %s...", pluginName));
            String subDir = String.valueOf(this.dropinsDir) + "/" + pluginName;
            Util.deleteDirectory((String)subDir, (boolean)false);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void installPlugin(String pluginName) {
        try {
            this.setStatus(String.format("Installing %s...", pluginName));
            String subDir = String.valueOf(this.dropinsDir) + "/" + pluginName + "/";
            URL url = new URL(String.valueOf(this.repository) + "/" + pluginName + ".zip");
            URLConnection urlConnection = url.openConnection();
            Path subDirPath = Paths.get(subDir, new String[0]);
            try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(urlConnection.getInputStream()));){
                ZipUtil.safeUnzip((ZipInputStream)zis, (Path)subDirPath);
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
            this.removePlugin(pluginName);
        }
    }

    private List<PluginInfo> loadInfoList(URL url) {
        ArrayList<PluginInfo> list = new ArrayList<PluginInfo>();
        try {
            DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
            Fact.setValidating(false);
            URLConnection urlConnection = url.openConnection();
            Document doc = Fact.newDocumentBuilder().parse(urlConnection.getInputStream());
            Element rootElem = doc.getDocumentElement();
            if (!rootElem.getNodeName().equals("pluginsDeployment")) {
                throw new OkapiException("Invalid description file.");
            }
            NodeList nodes = doc.getElementsByTagName("plugin");
            for (int i = 0; i < nodes.getLength(); ++i) {
                String helpURL;
                Element elem = (Element)nodes.item(i);
                String name = elem.getAttribute("name");
                if (Util.isEmpty((String)name)) {
                    throw new OkapiException("Invalid description file: missing name attribute.");
                }
                String description = null;
                NodeList list2 = elem.getElementsByTagName("description");
                if (list2.getLength() > 0) {
                    description = Util.getTextContent((Node)list2.item(0));
                }
                if (Util.isEmpty((String)(helpURL = elem.getAttribute("helpURL")))) {
                    helpURL = null;
                }
                list.add(new PluginInfo(name, elem.getAttribute("provider"), description, helpURL));
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
        return list;
    }
}

