/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml.ui;

import java.util.ResourceBundle;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.common.ui.ResponsiveTable;
import net.sf.okapi.common.ui.filters.InlineCodeFinderPanel;
import net.sf.okapi.common.ui.filters.ResponsiveTableFontMappingsInput;
import net.sf.okapi.common.ui.filters.ResponsiveTableFontMappingsOutput;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.StyleConfigurations;
import net.sf.okapi.filters.idml.ui.ResponsiveTableStyleConfigurationsInput;
import net.sf.okapi.filters.idml.ui.ResponsiveTableStyleConfigurationsOutput;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

interface Inputs {
    public void configureFrom(Parameters var1);

    public void saveTo(Parameters var1);

    public static final class Default
    implements Inputs {
        private final ResourceBundle resourceBundle;
        private final Shell shell;
        private Text maxAttributeSizeText;
        private Text specialCharacterPattern;
        private Button untagXmlStructuresButton;
        private Button mergeAdjacentCodes;
        private Button extractNotesButton;
        private Button extractMasterSpreadsButton;
        private Button extractHiddenLayersButton;
        private Button extractHiddenPasteboardItemsButton;
        private Button skipDiscretionaryHyphensButton;
        private Button extractBreaksInlineButton;
        private Button extractHyperlinkTextSourcesInlineButton;
        private Button extractCustomTextVariablesButton;
        private Button extractIndexTopicsButton;
        private Button extractExternalHyperlinksButton;
        private Button extractMathZonesButton;
        private ResponsiveTable excludedStyleTable;
        private ResponsiveTable fontMappingsTable;
        private Button ignoreCharacterKerningButton;
        private Text characterKerningMinIgnoranceThresholdText;
        private Text characterKerningMaxIgnoranceThresholdText;
        private Button ignoreCharacterTrackingButton;
        private Text characterTrackingMinIgnoranceThresholdText;
        private Text characterTrackingMaxIgnoranceThresholdText;
        private Button ignoreCharacterLeadingButton;
        private Text characterLeadingMinIgnoranceThresholdText;
        private Text characterLeadingMaxIgnoranceThresholdText;
        private Button ignoreCharacterBaselineShiftButton;
        private Text characterBaselineShiftMinIgnoranceThresholdText;
        private Text characterBaselineShiftMaxIgnoranceThresholdText;
        private Button useCodefinderButton;
        private InlineCodeFinderPanel pnlCodeFinder;

        Default(ResourceBundle resourceBundle, Shell shell) {
            this.resourceBundle = resourceBundle;
            this.shell = shell;
        }

        @Override
        public void configureFrom(Parameters parameters) {
            TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
            tabFolder.setLayoutData((Object)new GridData(1808));
            this.configureFirstTabItemFor(tabFolder, "general", parameters);
            this.configureSecondTabItemFor(tabFolder, "formatting", parameters);
        }

        private void configureFirstTabItemFor(TabFolder tabFolder, String key, Parameters parameters) {
            TabItem ti = new TabItem(tabFolder, 0);
            ti.setText(this.resourceBundle.getString(key));
            Composite tic = new Composite((Composite)tabFolder, 0);
            ti.setControl((Control)tic);
            tic.setLayout((Layout)new GridLayout(2, false));
            Composite tilc = new Composite(tic, 0);
            tilc.setLayout((Layout)new GridLayout());
            tilc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.maxAttributeSizeText = this.labelAndTextFor(tilc, "maximum-attribute-size", Integer.toUnsignedString(parameters.getMaxAttributeSize()));
            this.specialCharacterPattern = this.labelAndTextFor(tilc, "special-character-pattern", parameters.specialCharacterPattern().toString());
            this.untagXmlStructuresButton = this.buttonFor(tilc, "untag-xml-structures", parameters.getUntagXmlStructures());
            this.mergeAdjacentCodes = this.buttonFor(tilc, "merge-adjacent-codes", parameters.getMergeAdjacentCodes().orElse(false));
            this.extractNotesButton = this.buttonFor(tilc, "extract-notes", parameters.getExtractNotes());
            this.extractMasterSpreadsButton = this.buttonFor(tilc, "extract-master-spreads", parameters.getExtractMasterSpreads());
            this.extractHiddenLayersButton = this.buttonFor(tilc, "extract-hidden-layers", parameters.getExtractHiddenLayers());
            this.extractHiddenPasteboardItemsButton = this.buttonFor(tilc, "extract-hidden-pasteboard-items", parameters.getExtractHiddenPasteboardItems());
            this.skipDiscretionaryHyphensButton = this.buttonFor(tilc, "skip-discretionary-hyphens", parameters.getSkipDiscretionaryHyphens());
            this.extractBreaksInlineButton = this.buttonFor(tilc, "extract-breaks-inline", parameters.getExtractBreaksInline());
            this.extractHyperlinkTextSourcesInlineButton = this.buttonFor(tilc, "extract-hyperlink-text-sources-inline", parameters.getExtractHyperlinkTextSourcesInline());
            this.extractCustomTextVariablesButton = this.buttonFor(tilc, "extract-custom-text-variables", parameters.getExtractCustomTextVariables());
            this.extractIndexTopicsButton = this.buttonFor(tilc, "extract-index-topics", parameters.getExtractIndexTopics());
            this.extractExternalHyperlinksButton = this.buttonFor(tilc, "extract-external-hyperlinks", parameters.getExtractExternalHyperlinks());
            this.extractMathZonesButton = this.buttonFor(tilc, "extract-math-zone", parameters.getExtractMathZones());
            Composite tirc = new Composite(tic, 0);
            tirc.setLayout((Layout)new GridLayout());
            tirc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.useCodefinderButton = this.buttonFor(tirc, "use-codefinder", parameters.getUseCodeFinder());
            this.useCodefinderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.updateInlineCodes();
                }
            });
            this.pnlCodeFinder = new InlineCodeFinderPanel(tirc, 0);
            this.pnlCodeFinder.setLayoutData(new GridData(1808));
            this.pnlCodeFinder.setRules(parameters.getCodeFinder().toString());
            this.updateInlineCodes();
            this.pnlCodeFinder.updateDisplay();
        }

        private void configureSecondTabItemFor(TabFolder tabFolder, String key, Parameters parameters) {
            TabItem ti = new TabItem(tabFolder, 0);
            ti.setText(this.resourceBundle.getString(key));
            Composite tic = new Composite((Composite)tabFolder, 0);
            ti.setControl((Control)tic);
            tic.setLayout((Layout)new GridLayout(2, false));
            Composite tilc = new Composite(tic, 0);
            tilc.setLayout((Layout)new GridLayout());
            tilc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.labelFor(tilc, "excluded-styles");
            this.excludedStyleTable = (ResponsiveTable)parameters.excludedStyleConfigurations().writtenTo((StyleConfigurations.Output)new ResponsiveTableStyleConfigurationsOutput(new ResponsiveTable.Default(new Table(tilc, 67586), new Menu((Decorations)this.shell, 8), new Menu((Decorations)this.shell, 8))));
            this.labelFor(tilc, "font-mappings");
            this.fontMappingsTable = (ResponsiveTable)parameters.fontMappings().writtenTo((FontMappings.Output)new ResponsiveTableFontMappingsOutput(new ResponsiveTable.Default(new Table(tilc, 67586), new Menu((Decorations)this.shell, 8), new Menu((Decorations)this.shell, 8))));
            Composite tirc = new Composite(tic, 0);
            tirc.setLayout((Layout)new GridLayout());
            tirc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            Group g = new Group(tirc, 0);
            g.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            g.setLayout((Layout)new GridLayout());
            g.setText(this.resourceBundle.getString("ignored-styles"));
            this.ignoreCharacterKerningButton = this.buttonFor((Composite)g, "ignore-character-kerning", parameters.getIgnoreCharacterKerning());
            this.characterKerningMinIgnoranceThresholdText = this.labelAndTextFor((Composite)g, "character-kerning-minimum-ignorance-threshold", parameters.getCharacterKerningMinIgnoranceThreshold());
            this.characterKerningMaxIgnoranceThresholdText = this.labelAndTextFor((Composite)g, "character-kerning-maximum-ignorance-threshold", parameters.getCharacterKerningMaxIgnoranceThreshold());
            this.ignoreCharacterTrackingButton = this.buttonFor((Composite)g, "ignore-character-tracking", parameters.getIgnoreCharacterTracking());
            this.characterTrackingMinIgnoranceThresholdText = this.labelAndTextFor((Composite)g, "character-tracking-minimum-ignorance-threshold", parameters.getCharacterTrackingMinIgnoranceThreshold());
            this.characterTrackingMaxIgnoranceThresholdText = this.labelAndTextFor((Composite)g, "character-tracking-maximum-ignorance-threshold", parameters.getCharacterTrackingMaxIgnoranceThreshold());
            this.ignoreCharacterLeadingButton = this.buttonFor((Composite)g, "ignore-character-leading", parameters.getIgnoreCharacterLeading());
            this.characterLeadingMinIgnoranceThresholdText = this.labelAndTextFor((Composite)g, "character-leading-minimum-ignorance-threshold", parameters.getCharacterLeadingMinIgnoranceThreshold());
            this.characterLeadingMaxIgnoranceThresholdText = this.labelAndTextFor((Composite)g, "character-leading-maximum-ignorance-threshold", parameters.getCharacterLeadingMaxIgnoranceThreshold());
            this.ignoreCharacterBaselineShiftButton = this.buttonFor((Composite)g, "ignore-character-baseline-shift", parameters.getIgnoreCharacterBaselineShift());
            this.characterBaselineShiftMinIgnoranceThresholdText = this.labelAndTextFor((Composite)g, "character-baseline-shift-minimum-ignorance-threshold", parameters.getCharacterBaselineShiftMinIgnoranceThreshold());
            this.characterBaselineShiftMaxIgnoranceThresholdText = this.labelAndTextFor((Composite)g, "character-baseline-shift-maximum-ignorance-threshold", parameters.getCharacterBaselineShiftMaxIgnoranceThreshold());
        }

        private Button buttonFor(Composite composite, String key, boolean selection) {
            Button b = new Button(composite, 32);
            b.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            b.setText(this.resourceBundle.getString(key));
            b.setSelection(selection);
            return b;
        }

        private Label labelFor(Composite composite, String key) {
            Label l = new Label(composite, 0);
            l.setText(this.resourceBundle.getString(key));
            return l;
        }

        private Text textFor(Composite composite, String text) {
            Text t = new Text(composite, 2048);
            t.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            t.setText(text);
            return t;
        }

        private Text labelAndTextFor(Composite composite, String labelKey, String text) {
            this.labelFor(composite, labelKey);
            return this.textFor(composite, text);
        }

        @Override
        public void saveTo(Parameters parameters) {
            parameters.setMaxAttributeSize(Integer.parseUnsignedInt(this.maxAttributeSizeText.getText()));
            parameters.specialCharacterPattern(this.specialCharacterPattern.getText());
            parameters.setUntagXmlStructures(this.untagXmlStructuresButton.getSelection());
            parameters.setMergeAdjacentCodes(this.mergeAdjacentCodes.getSelection());
            parameters.setExtractNotes(this.extractNotesButton.getSelection());
            parameters.setExtractMasterSpreads(this.extractMasterSpreadsButton.getSelection());
            parameters.setExtractHiddenLayers(this.extractHiddenLayersButton.getSelection());
            parameters.setExtractHiddenPasteboardItems(this.extractHiddenPasteboardItemsButton.getSelection());
            parameters.setSkipDiscretionaryHyphens(this.skipDiscretionaryHyphensButton.getSelection());
            parameters.setExtractBreaksInline(this.extractBreaksInlineButton.getSelection());
            parameters.setExtractHyperlinkTextSourcesInline(this.extractHyperlinkTextSourcesInlineButton.getSelection());
            parameters.setExtractCustomTextVariables(this.extractCustomTextVariablesButton.getSelection());
            parameters.setExtractIndexTopics(this.extractIndexTopicsButton.getSelection());
            parameters.setExtractExternalHyperlinks(this.extractExternalHyperlinksButton.getSelection());
            parameters.setExtractMathZones(this.extractMathZonesButton.getSelection());
            parameters.excludedStyleConfigurations().addFrom((StyleConfigurations.Input)new ResponsiveTableStyleConfigurationsInput(this.excludedStyleTable));
            parameters.fontMappings().addFrom((FontMappings.Input)new ResponsiveTableFontMappingsInput(this.fontMappingsTable));
            parameters.setIgnoreCharacterKerning(this.ignoreCharacterKerningButton.getSelection());
            parameters.setCharacterKerningMinIgnoranceThreshold(this.characterKerningMinIgnoranceThresholdText.getText());
            parameters.setCharacterKerningMaxIgnoranceThreshold(this.characterKerningMaxIgnoranceThresholdText.getText());
            parameters.setIgnoreCharacterTracking(this.ignoreCharacterTrackingButton.getSelection());
            parameters.setCharacterTrackingMinIgnoranceThreshold(this.characterTrackingMinIgnoranceThresholdText.getText());
            parameters.setCharacterTrackingMaxIgnoranceThreshold(this.characterTrackingMaxIgnoranceThresholdText.getText());
            parameters.setIgnoreCharacterLeading(this.ignoreCharacterLeadingButton.getSelection());
            parameters.setCharacterLeadingMinIgnoranceThreshold(this.characterLeadingMinIgnoranceThresholdText.getText());
            parameters.setCharacterLeadingMaxIgnoranceThreshold(this.characterLeadingMaxIgnoranceThresholdText.getText());
            parameters.setIgnoreCharacterBaselineShift(this.ignoreCharacterBaselineShiftButton.getSelection());
            parameters.setCharacterBaselineShiftMinIgnoranceThreshold(this.characterBaselineShiftMinIgnoranceThresholdText.getText());
            parameters.setCharacterBaselineShiftMaxIgnoranceThreshold(this.characterBaselineShiftMaxIgnoranceThresholdText.getText());
            parameters.setUseCodeFinder(this.useCodefinderButton.getSelection());
            if (this.useCodefinderButton.getSelection()) {
                parameters.setCodeFinderData(this.pnlCodeFinder.getRules());
            }
        }

        private void updateInlineCodes() {
            this.pnlCodeFinder.setEnabled(this.useCodefinderButton.getSelection());
        }
    }
}

