/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.po.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.filters.InlineCodeFinderPanel;
import net.sf.okapi.filters.po.Parameters;
import net.sf.okapi.filters.po.ui.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class Editor
implements IParametersEditor {
    private Shell shell;
    private boolean result = false;
    private Button chkProtectApproved;
    private Button includeMsgCtxtInNote;
    private Button rdBilingualMode;
    private Text edBModeNote;
    private Button rdMonolingualMode;
    private Text edMModeNote;
    private Button chkMakeID;
    private Text edSubfilterId;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Button chkUseCodeFinder;
    private InlineCodeFinderPanel pnlCodeFinder;
    private IHelp help;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters p_Options, boolean readOnly, IContext context) {
        this.help = (IHelp)context.getObject("help");
        boolean bRes = false;
        this.shell = null;
        this.params = (Parameters)p_Options;
        try {
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception E) {
            Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    private void create(Shell p_Parent, boolean readOnly) {
        this.shell.setText(Res.getString("editorCaption"));
        if (p_Parent != null) {
            this.shell.setImage(p_Parent.getImage());
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        TabFolder tfTmp = new TabFolder((Composite)this.shell, 0);
        GridData gdTmp = new GridData(1808);
        tfTmp.setLayoutData((Object)gdTmp);
        Composite cmpTmp = new Composite((Composite)tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout((Layout)layTmp);
        this.chkProtectApproved = new Button(cmpTmp, 32);
        this.chkProtectApproved.setText(Res.getString("protectApproved"));
        this.includeMsgCtxtInNote = new Button(cmpTmp, 32);
        this.includeMsgCtxtInNote.setText(Res.getString("includeMsgCtxtInNote"));
        Group grpTmp = new Group(cmpTmp, 0);
        layTmp = new GridLayout();
        grpTmp.setLayout((Layout)layTmp);
        grpTmp.setText(Res.getString("modeTitle"));
        gdTmp = new GridData(1808);
        grpTmp.setLayoutData((Object)gdTmp);
        this.rdBilingualMode = new Button((Composite)grpTmp, 16);
        this.rdBilingualMode.setText(Res.getString("bilingualMode"));
        this.rdBilingualMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateOptions();
            }
        });
        this.edBModeNote = new Text((Composite)grpTmp, 2114);
        this.edBModeNote.setText(Res.getString("bilingualNote"));
        this.edBModeNote.setEditable(false);
        gdTmp = new GridData(1808);
        gdTmp.horizontalIndent = 16;
        gdTmp.widthHint = 200;
        this.edBModeNote.setLayoutData((Object)gdTmp);
        this.chkMakeID = new Button((Composite)grpTmp, 32);
        this.chkMakeID.setText(Res.getString("makeID"));
        gdTmp = new GridData();
        gdTmp.horizontalIndent = 16;
        this.chkMakeID.setLayoutData((Object)gdTmp);
        this.rdMonolingualMode = new Button((Composite)grpTmp, 16);
        this.rdMonolingualMode.setText(Res.getString("monolingualMode"));
        this.rdMonolingualMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateOptions();
            }
        });
        this.edMModeNote = new Text((Composite)grpTmp, 2114);
        this.edMModeNote.setText(Res.getString("monolingualNote"));
        this.edMModeNote.setEditable(false);
        gdTmp = new GridData(1808);
        gdTmp.horizontalIndent = 16;
        gdTmp.widthHint = 200;
        this.edMModeNote.setLayoutData((Object)gdTmp);
        TabItem tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText(Res.getString("tabOptions"));
        tiTmp.setControl((Control)cmpTmp);
        cmpTmp = new Composite((Composite)tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout((Layout)layTmp);
        Label stSubFilter = new Label((Composite)grpTmp, 0);
        stSubFilter.setText(Res.getString("subfilter"));
        this.edSubfilterId = new Text((Composite)grpTmp, 2048);
        gdTmp = new GridData(768);
        this.edSubfilterId.setLayoutData((Object)gdTmp);
        this.chkUseCodeFinder = new Button(cmpTmp, 32);
        this.chkUseCodeFinder.setText("Has inline codes as defined below:");
        this.chkUseCodeFinder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateInlineCodes();
            }
        });
        this.pnlCodeFinder = new InlineCodeFinderPanel(cmpTmp, 0);
        this.pnlCodeFinder.setLayoutData(new GridData(1808));
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Inline Codes");
        tiTmp.setControl((Control)cmpTmp);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("PO Filter");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!Editor.this.saveData()) {
                        return;
                    }
                    Editor.this.result = true;
                }
                Editor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true);
        gdTmp = new GridData(768);
        this.pnlActions.setLayoutData(gdTmp);
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Dialogs.centerWindow(this.shell, p_Parent);
        this.setData();
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void updateOptions() {
        this.edBModeNote.setEnabled(this.rdBilingualMode.getSelection());
        this.chkMakeID.setEnabled(this.rdBilingualMode.getSelection());
        this.edMModeNote.setEnabled(this.rdMonolingualMode.getSelection());
    }

    private void setData() {
        this.chkProtectApproved.setSelection(this.params.getProtectApproved());
        this.includeMsgCtxtInNote.setSelection(this.params.getIncludeMsgContextInNote());
        this.rdBilingualMode.setSelection(this.params.getBilingualMode());
        this.rdMonolingualMode.setSelection(!this.params.getBilingualMode());
        this.chkMakeID.setSelection(this.params.getMakeID());
        this.edSubfilterId.setText(this.params.getSubfilter() == null ? "" : this.params.getSubfilter());
        this.updateOptions();
        this.chkUseCodeFinder.setSelection(this.params.getUseCodeFinder());
        this.pnlCodeFinder.setRules(this.params.getCodeFinder().toString());
        this.updateInlineCodes();
        this.pnlCodeFinder.updateDisplay();
    }

    private boolean saveData() {
        String tmp = this.pnlCodeFinder.getRules();
        if (tmp == null) {
            return false;
        }
        this.params.getCodeFinder().fromString(tmp);
        this.params.setProtectApproved(this.chkProtectApproved.getSelection());
        this.params.setIncludeMsgContextInNote(this.includeMsgCtxtInNote.getSelection());
        this.params.setMakeID(this.chkMakeID.getSelection());
        this.params.setBilingualMode(this.rdBilingualMode.getSelection());
        this.params.setSubfilter(this.edSubfilterId.getText());
        this.params.setUseCodeFinder(this.chkUseCodeFinder.getSelection());
        return true;
    }

    private void updateInlineCodes() {
        boolean useCodeFinder = this.chkUseCodeFinder.getSelection();
        this.pnlCodeFinder.setEnabled(useCodeFinder);
    }
}

