/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.rainbowkit.ui;

import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.filters.rainbowkit.IManifestEditor;
import net.sf.okapi.filters.rainbowkit.Manifest;
import net.sf.okapi.filters.rainbowkit.ui.ManifestTableModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ManifestDialog
implements IManifestEditor {
    private Shell shell;
    private Manifest manifest;
    private ManifestTableModel tableMod;
    private SelectionAdapter CloseActions;
    private boolean result;
    private Text edProjectId;
    private Text edPkgID;
    private Text edSource;
    private Text edTarget;
    private Text edDate;
    private Text edTargetDirectory;
    private Button chkUseApprovedOnly;
    private Button chkUpdateApprovedFlag;

    private void create(Shell parent, boolean inProcess) {
        this.result = false;
        this.shell = new Shell(parent, 65648);
        this.shell.setText("Translation Kit Manifest");
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout((Layout)new GridLayout());
        TabFolder tfTmp = new TabFolder((Composite)this.shell, 0);
        tfTmp.setLayoutData((Object)new GridData(1808));
        Composite cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        TabItem tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Documents");
        tiTmp.setControl((Control)cmpTmp);
        Table tableDocs = new Table(cmpTmp, 68130);
        GridData gdTmp = new GridData(1808);
        gdTmp.minimumHeight = 300;
        gdTmp.minimumWidth = 550;
        tableDocs.setLayoutData((Object)gdTmp);
        tableDocs.setHeaderVisible(true);
        tableDocs.setLinesVisible(true);
        this.tableMod = new ManifestTableModel();
        this.tableMod.linkTable(tableDocs);
        this.edTargetDirectory = new Text(cmpTmp, 2048);
        this.edTargetDirectory.setLayoutData((Object)new GridData(768));
        this.edTargetDirectory.setEditable(false);
        cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Options");
        tiTmp.setControl((Control)cmpTmp);
        this.chkUseApprovedOnly = new Button(cmpTmp, 32);
        this.chkUseApprovedOnly.setText("Merge the translation only if it is approved");
        this.chkUpdateApprovedFlag = new Button(cmpTmp, 32);
        this.chkUpdateApprovedFlag.setText("Update the 'approved' flag on the merged translations (for applicable formats)");
        cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout(2, false));
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Information");
        tiTmp.setControl((Control)cmpTmp);
        Label stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Project ID:");
        stTmp.setLayoutData((Object)new GridData());
        this.edProjectId = new Text(cmpTmp, 2048);
        this.edProjectId.setLayoutData((Object)new GridData(768));
        this.edProjectId.setEditable(false);
        stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Package ID:");
        stTmp.setLayoutData((Object)new GridData());
        this.edPkgID = new Text(cmpTmp, 2048);
        this.edPkgID.setLayoutData((Object)new GridData(768));
        this.edPkgID.setEditable(false);
        stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Source locale:");
        stTmp.setLayoutData((Object)new GridData());
        this.edSource = new Text(cmpTmp, 2048);
        this.edSource.setLayoutData((Object)new GridData(768));
        this.edSource.setEditable(false);
        stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Target locale:");
        stTmp.setLayoutData((Object)new GridData());
        this.edTarget = new Text(cmpTmp, 2048);
        this.edTarget.setLayoutData((Object)new GridData(768));
        this.edTarget.setEditable(false);
        stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Creation date:");
        stTmp.setLayoutData((Object)new GridData());
        this.edDate = new Text(cmpTmp, 2048);
        this.edDate.setLayoutData((Object)new GridData(768));
        this.edDate.setEditable(false);
        this.CloseActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    Util.openWikiTopic((String)"Rainbow Translation Kit Manifest");
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    ManifestDialog.this.tableMod.saveData();
                    ManifestDialog.this.manifest.setUseApprovedOnly(ManifestDialog.this.chkUseApprovedOnly.getSelection());
                    ManifestDialog.this.manifest.setUpdateApprovedFlag(ManifestDialog.this.chkUpdateApprovedFlag.getSelection());
                    ManifestDialog.this.manifest.save(null);
                    ManifestDialog.this.result = true;
                }
                ManifestDialog.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel((Composite)this.shell, 0, this.CloseActions, true, inProcess ? "Continue" : "OK");
        pnlActions.setLayoutData(new GridData(768));
        this.shell.setDefaultButton(pnlActions.btOK);
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 450) {
            startSize.x = 450;
        }
        this.shell.setSize(startSize);
        Rectangle rect = tableDocs.getClientArea();
        int nPart = rect.width / 100;
        tableDocs.getColumn(0).setWidth(45 * nPart);
        tableDocs.getColumn(1).setWidth(15 * nPart);
        tableDocs.getColumn(2).setWidth(rect.width - 60 * nPart);
        Dialogs.centerWindow(this.shell, parent);
    }

    private void setData(Manifest manifest) {
        this.manifest = manifest;
        this.edTargetDirectory.setText(manifest.getTempTargetDirectory());
        this.edProjectId.setText(manifest.getProjectId());
        this.edPkgID.setText(manifest.getPackageId());
        this.edSource.setText(manifest.getSourceLocale().toString());
        this.edTarget.setText(manifest.getTargetLocale().toString());
        this.edDate.setText(manifest.getDate());
        this.chkUseApprovedOnly.setSelection(manifest.getUseApprovedOnly());
        this.chkUpdateApprovedFlag.setSelection(manifest.getUpdateApprovedFlag());
    }

    private boolean showDialog(Manifest manifest) {
        this.tableMod.setManifest(manifest);
        this.setData(manifest);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    public boolean edit(Object parent, Manifest manifest, boolean inProcess) {
        Shell shell = null;
        if (parent != null && parent instanceof Shell) {
            shell = (Shell)parent;
        }
        this.create(shell, inProcess);
        boolean res = this.showDialog(manifest);
        return res;
    }
}

