/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.rainbowkit.ui;

import java.util.Iterator;
import net.sf.okapi.filters.rainbowkit.Manifest;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class ManifestTableModel {
    private Table table;
    private Manifest manifest;

    ManifestTableModel() {
    }

    public void linkTable(Table newTable) {
        this.table = newTable;
        TableColumn col = new TableColumn(this.table, 0);
        col.setText("Documents to Post-Process");
        col = new TableColumn(this.table, 0);
        col.setText("Missing?");
        col = new TableColumn(this.table, 0);
        col.setText("Output");
    }

    public void setManifest(Manifest newManifest) {
        this.manifest = newManifest;
        this.updateTable(null, 0);
    }

    void updateTable(int[] selection, int index) {
        this.table.removeAll();
        Iterator iterator = this.manifest.getItems().keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            MergingInfo info = this.manifest.getItem(i);
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, info.getRelativeInputPath());
            item.setText(2, info.getRelativeTargetPath());
            item.setChecked(info.getSelected());
        }
        if (selection == null) {
            if (this.table.getItemCount() > 0) {
                if (index > -1) {
                    if (index > this.table.getItemCount() - 1) {
                        index = this.table.getItemCount() - 1;
                    }
                } else {
                    index = 0;
                }
                this.table.setSelection(index);
            }
        } else {
            this.table.setSelection(selection);
        }
    }

    public void saveData() {
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            MergingInfo info = this.manifest.getItem(i + 1);
            if (info == null) continue;
            info.setSelected(this.table.getItem(i).getChecked());
        }
    }
}

