/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.translation;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.plugins.PluginItem;
import net.sf.okapi.common.plugins.PluginsManager;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.lib.ui.translation.ConnectorInfo;
import net.sf.okapi.lib.ui.translation.IConnectorList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectors
implements IConnectorList {
    private ArrayList<ConnectorInfo> list = new ArrayList();
    private static IConnectorList connectors = new DefaultConnectors();

    public DefaultConnectors() {
        this.setDefaultMapping();
    }

    private void setDefaultMapping() {
        ConnectorInfo trc = new ConnectorInfo();
        trc.description = "Pensieve TM Engine";
        trc.connectorClass = "net.sf.okapi.connectors.pensieve.PensieveTMConnector";
        trc.descriptionProviderClass = "net.sf.okapi.connectors.pensieve.Parameters";
        this.list.add(trc);
        trc = new ConnectorInfo();
        trc.description = "Google Translate Services (v2, paid service)";
        trc.connectorClass = "net.sf.okapi.connectors.google.GoogleMTv2Connector";
        trc.descriptionProviderClass = "net.sf.okapi.connectors.google.GoogleMTv2Parameters";
        this.list.add(trc);
        trc = new ConnectorInfo();
        trc.description = "Google AutoML Translation Services";
        trc.connectorClass = "net.sf.okapi.connectors.googleautoml.GoogleAutoMLTranslationConnector";
        trc.descriptionProviderClass = "net.sf.okapi.connectors.googleautoml.GoogleAutoMLTranslationParameters";
        this.list.add(trc);
        trc = new ConnectorInfo();
        trc.description = "MyMemory TM Web Services";
        trc.connectorClass = "net.sf.okapi.connectors.mymemory.MyMemoryTMConnector";
        trc.descriptionProviderClass = "net.sf.okapi.connectors.mymemory.Parameters";
        this.list.add(trc);
        trc = new ConnectorInfo();
        trc.description = "Translate Toolkit TM Server";
        trc.connectorClass = "net.sf.okapi.connectors.translatetoolkit.TranslateToolkitTMConnector";
        trc.descriptionProviderClass = "net.sf.okapi.connectors.translatetoolkit.Parameters";
        this.list.add(trc);
        trc = new ConnectorInfo();
        trc.description = "Apertium MT Web Server";
        trc.connectorClass = "net.sf.okapi.connectors.apertium.ApertiumMTConnector";
        trc.descriptionProviderClass = "net.sf.okapi.connectors.apertium.Parameters";
        this.list.add(trc);
        trc = new ConnectorInfo();
        trc.description = "Microsoft Translator Services";
        trc.connectorClass = "net.sf.okapi.connectors.microsoft.MicrosoftMTConnector";
        trc.descriptionProviderClass = "net.sf.okapi.connectors.microsoft.Parameters";
        this.list.add(trc);
        trc = new ConnectorInfo();
        trc.description = "KantanMT v2.1";
        trc.connectorClass = "net.sf.okapi.connectors.kantan.KantanMTv21Connector";
        trc.descriptionProviderClass = "net.sf.okapi.connectors.kantan.KantanMTv21ConnectorParameters";
        this.list.add(trc);
        trc = new ConnectorInfo();
        trc.description = "Bilingual File";
        trc.connectorClass = "net.sf.okapi.connectors.bifile.BilingualFileConnector";
        trc.descriptionProviderClass = "net.sf.okapi.connectors.bifile.Parameters";
        this.list.add(trc);
        trc = new ConnectorInfo();
        trc.description = "Lingo24 Premium MT API";
        trc.connectorClass = "net.sf.okapi.connectors.lingo24.Lingo24Connector";
        trc.descriptionProviderClass = "net.sf.okapi.connectors.lingo24.Parameters";
        this.list.add(trc);
        trc = new ConnectorInfo();
        trc.description = "ModernMT API";
        trc.connectorClass = "net.sf.okapi.connectors.mmt.MMTConnector";
        trc.descriptionProviderClass = "net.sf.okapi.connectors.mmt.Parameters";
        this.list.add(trc);
    }

    @Override
    public List<ConnectorInfo> getList() {
        return this.list;
    }

    public static void setConnectors(IConnectorList connectors) {
        DefaultConnectors.connectors = connectors;
    }

    public static IConnectorList getConnectors() {
        return connectors;
    }

    private static String getName(String connectorClass, ClassLoader classLoader) {
        IQuery connector = null;
        try {
            connector = (IQuery)ClassUtil.instantiateClass((String)connectorClass, (ClassLoader)classLoader);
        }
        catch (Exception e) {
            Logger localLogger = LoggerFactory.getLogger(DefaultConnectors.class);
            localLogger.warn("Cannot instantiate the connector '{}'.", (Object)connectorClass);
            return "Unknown plug-in connector";
        }
        return connector.getName();
    }

    public static void addFromPlugins(PluginsManager pm) {
        List list = pm.getList();
        for (PluginItem item : list) {
            if (item.getType() != 32) continue;
            ConnectorInfo trc = new ConnectorInfo();
            trc.description = DefaultConnectors.getName(item.getClassName(), pm.getClassLoader());
            trc.connectorClass = item.getClassName();
            trc.descriptionProviderClass = item.getEditorDescriptionProvider() == null ? null : item.getEditorDescriptionProvider().name;
            trc.classLoader = pm.getClassLoader();
            connectors.getList().add(trc);
        }
    }
}

