/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.verification;

import java.io.File;
import java.net.URI;
import java.util.Map;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.InputDocumentDialog;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.lib.verification.QualityCheckSession;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class SessionSettingsDialog {
    private Shell dialog;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private IHelp help;
    private QualityCheckSession session;
    private Text edSourceLocale;
    private Text edTargetLocale;
    private List lbDocs;
    private Button btRemove;
    private Button btRemoveAll;
    private Button chkAutoRefresh;

    public SessionSettingsDialog(Shell parent, IHelp paramHelp) {
        this.help = paramHelp;
        this.dialog = new Shell(parent, 65648);
        this.dialog.setText("Session Settings");
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setLayoutData((Object)new GridData(1808));
        UIUtil.inheritIcon(this.dialog, parent);
        Group grpDocs = new Group((Composite)this.dialog, 0);
        grpDocs.setText("Documents");
        grpDocs.setLayout((Layout)new GridLayout(4, false));
        grpDocs.setLayoutData((Object)new GridData(1808));
        this.lbDocs = new List((Composite)grpDocs, 2818);
        GridData gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 4;
        this.lbDocs.setLayoutData((Object)gdTmp);
        Button btAdd = UIUtil.createGridButton((Composite)grpDocs, 8, "Add...", 80, 1);
        btAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionSettingsDialog.this.addDocument();
            }
        });
        this.btRemove = UIUtil.createGridButton((Composite)grpDocs, 8, "Remove...", 80, 1);
        this.btRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionSettingsDialog.this.removeDocument();
            }
        });
        this.btRemoveAll = UIUtil.createGridButton((Composite)grpDocs, 8, "Remove All", 80, 1);
        this.btRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionSettingsDialog.this.removeAll();
            }
        });
        this.chkAutoRefresh = new Button((Composite)grpDocs, 32);
        this.chkAutoRefresh.setText("Re-check documents automatically when they change");
        this.chkAutoRefresh.setLayoutData((Object)new GridData(128));
        Group grpLocales = new Group((Composite)this.dialog, 0);
        grpLocales.setText("Locales");
        grpLocales.setLayout((Layout)new GridLayout(2, false));
        grpLocales.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)grpLocales, 0);
        label.setText("Source locale:");
        this.edSourceLocale = new Text((Composite)grpLocales, 2048);
        gdTmp = new GridData();
        gdTmp.widthHint = 100;
        this.edSourceLocale.setLayoutData((Object)gdTmp);
        label = new Label((Composite)grpLocales, 0);
        label.setText("Target locale:");
        this.edTargetLocale = new Text((Composite)grpLocales, 2048);
        gdTmp = new GridData();
        gdTmp.widthHint = 100;
        this.edTargetLocale.setLayoutData((Object)gdTmp);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionSettingsDialog.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (SessionSettingsDialog.this.help != null) {
                        SessionSettingsDialog.this.help.showWiki("CheckMate - Session Settings");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!SessionSettingsDialog.this.saveData()) {
                        return;
                    }
                    SessionSettingsDialog.this.result = true;
                }
                SessionSettingsDialog.this.dialog.close();
            }
        };
        this.pnlActions = new OKCancelPanel((Composite)this.dialog, 0, OKCancelActions, true);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.pnlActions.setLayoutData(gdTmp);
        this.dialog.pack();
        Point size = this.dialog.getSize();
        this.dialog.setMinimumSize(size);
        if (size.x < 630) {
            size.x = 630;
        }
        if (size.y < 400) {
            size.y = 400;
        }
        this.dialog.setSize(size);
        Dialogs.centerWindow(this.dialog, parent);
    }

    private void removeDocument() {
        int n = this.lbDocs.getSelectionIndex();
        if (n < 0) {
            return;
        }
        this.lbDocs.remove(n);
        if (n >= this.lbDocs.getItemCount()) {
            n = this.lbDocs.getItemCount() - 1;
        }
        this.lbDocs.setSelection(n);
        this.updateFileButtons();
    }

    private void removeAll() {
        this.lbDocs.removeAll();
        this.updateFileButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocument() {
        try {
            InputDocumentDialog dlg = new InputDocumentDialog(this.dialog, "Input Document", this.session.getFilterConfigurationMapper(), false);
            dlg.setData(null, null, "UTF-8", this.session.getSourceLocale(), this.session.getTargetLocale());
            dlg.setLocalesEditable(this.lbDocs.getItemCount() == 0);
            Object[] data = dlg.showDialog();
            if (data == null) {
                return;
            }
            URI uri = new File((String)data[0]).toURI();
            RawDocument rd = new RawDocument(uri, (String)data[2], (LocaleId)data[3], (LocaleId)data[4]);
            rd.setFilterConfigId((String)data[1]);
            this.lbDocs.add(this.formatDocument(rd));
            this.lbDocs.setSelection(this.lbDocs.getItemCount() - 1);
            if (this.lbDocs.getItemCount() == 1) {
                this.edSourceLocale.setText(((LocaleId)data[3]).toString());
                this.edTargetLocale.setText(((LocaleId)data[4]).toString());
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.dialog, "Error adding document.\n" + e.getMessage(), null);
        }
        finally {
            this.updateFileButtons();
        }
    }

    private String formatDocument(RawDocument rd) {
        return String.format("%s    \t(%s,  %s)", rd.getInputURI().getPath(), rd.getFilterConfigId(), rd.getEncoding());
    }

    private String[] explodeDocument(String doc) {
        String[] res = new String[3];
        String[] tmp = doc.split("\t");
        res[0] = tmp[0].trim();
        tmp = tmp[1].split(",");
        res[1] = tmp[0].substring(1);
        res[2] = tmp[1].trim();
        res[2] = res[2].substring(0, res[2].length() - 1);
        return res;
    }

    private void updateFileButtons() {
        this.btRemove.setEnabled(this.lbDocs.getSelectionIndex() > -1);
        this.btRemoveAll.setEnabled(this.lbDocs.getItemCount() > 0);
    }

    public void setData(QualityCheckSession session) {
        this.session = session;
        for (RawDocument rd : session.getDocuments()) {
            this.lbDocs.add(this.formatDocument(rd));
        }
        if (this.lbDocs.getItemCount() > 0) {
            this.lbDocs.setSelection(0);
        }
        this.chkAutoRefresh.setSelection(session.getAutoRefresh());
        this.edSourceLocale.setText(session.getSourceLocale().toString());
        this.edTargetLocale.setText(session.getTargetLocale().toString());
        this.updateFileButtons();
    }

    private boolean saveData() {
        LocaleId trgLoc;
        LocaleId srcLoc;
        String tmp = this.edSourceLocale.getText().trim();
        try {
            srcLoc = LocaleId.fromString((String)tmp);
        }
        catch (Throwable e) {
            Dialogs.showError(this.dialog, String.format("The source locale '%s' is not a valid locale.", tmp), null);
            this.edSourceLocale.setFocus();
            return false;
        }
        tmp = this.edTargetLocale.getText();
        try {
            trgLoc = LocaleId.fromString((String)tmp);
        }
        catch (Throwable e) {
            Dialogs.showError(this.dialog, String.format("The target locale '%s' is not a valid locale.", tmp), null);
            this.edTargetLocale.setFocus();
            return false;
        }
        this.session.setAutoRefresh(this.chkAutoRefresh.getSelection());
        this.session.setSourceLocale(srcLoc);
        this.session.setTargetLocale(trgLoc);
        Map docs = this.session.getDocumentsMap();
        docs.clear();
        for (String item : this.lbDocs.getItems()) {
            String[] res = this.explodeDocument(item);
            try {
                URI uri = new File(res[0]).toURI();
                RawDocument rd = new RawDocument(uri, res[2], srcLoc, trgLoc);
                rd.setFilterConfigId(res[1]);
                this.session.addRawDocument(rd);
            }
            catch (Throwable e) {
                Dialogs.showError(this.dialog, String.format("Error with: %s", res[0]), null);
                return false;
            }
        }
        return true;
    }

    public boolean showDialog() {
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        return this.result;
    }
}

