/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.encodingconversion.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.ISWTEmbeddableParametersEditor;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.steps.encodingconversion.Parameters;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class ParametersEditor
implements IParametersEditor,
ISWTEmbeddableParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Button chkUnescapeNCR;
    private Button chkUnescapeCER;
    private Button chkUnescapeJava;
    private Button rdEscapeToNCRHexaU;
    private Button rdEscapeToNCRHexaL;
    private Button rdEscapeToNCRDeci;
    private Button rdEscapeToCER;
    private Button rdEscapeToJavaU;
    private Button rdEscapeToJavaL;
    private Button rdEscapeToUserFormat;
    private Text edUserFormat;
    private Button rdEscapeUnsupported;
    private Button rdEscapeAll;
    private String formattedOutput;
    private Button chkUseBytes;
    private Button chkBOMonUTF8;
    private Button chkReportUnsupported;
    private IHelp help;
    private Composite mainComposite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.shell = null;
            this.help = (IHelp)context.getObject("help");
            this.params = (Parameters)params;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    @Override
    public void initializeEmbeddableEditor(Composite parent, IParameters paramsObject, IContext context) {
        this.params = (Parameters)paramsObject;
        this.shell = (Shell)context.getObject("shell");
        this.createComposite(parent);
        this.setData();
    }

    public String validateAndSaveParameters() {
        if (!this.saveData()) {
            return null;
        }
        return this.params.toString();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("Encoding Conversion");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        this.createComposite((Composite)this.shell);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (ParametersEditor.this.help != null) {
                        ParametersEditor.this.help.showWiki("Encoding Conversion Step");
                    }
                    return;
                }
                if (e.widget.getData().equals("o") && !ParametersEditor.this.saveData()) {
                    return;
                }
                ParametersEditor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData(new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.setData();
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Dialogs.centerWindow(this.shell, parent);
    }

    private void createComposite(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        GridLayout layTmp = new GridLayout();
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        this.mainComposite.setLayout((Layout)layTmp);
        TabFolder tfTmp = new TabFolder(this.mainComposite, 0);
        tfTmp.setLayoutData((Object)new GridData(1808));
        Composite cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        TabItem tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Input");
        tiTmp.setControl((Control)cmpTmp);
        Group group = new Group(cmpTmp, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText("Un-escape the following notations");
        group.setLayoutData((Object)new GridData(768));
        this.chkUnescapeNCR = new Button((Composite)group, 32);
        this.chkUnescapeNCR.setText("Numeric character references (&&#225; or &&#xE1; or &&&xe1; --> \u00e1)");
        this.chkUnescapeCER = new Button((Composite)group, 32);
        this.chkUnescapeCER.setText("Character entity references (&&aacute; --> \u00e1)");
        this.chkUnescapeJava = new Button((Composite)group, 32);
        this.chkUnescapeJava.setText("Java-style escape notation (\\u00E1 or \\u00e1 --> \u00e1)");
        cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Output");
        tiTmp.setControl((Control)cmpTmp);
        group = new Group(cmpTmp, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText("What characters should be escaped");
        group.setLayoutData((Object)new GridData(768));
        this.rdEscapeUnsupported = new Button((Composite)group, 16);
        this.rdEscapeUnsupported.setText("Only the characters un-supported by the output encoding");
        this.rdEscapeAll = new Button((Composite)group, 16);
        this.rdEscapeAll.setText("All extended characters");
        group = new Group(cmpTmp, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText("Escape notation to use");
        group.setLayoutData((Object)new GridData(768));
        this.rdEscapeToNCRHexaU = new Button((Composite)group, 16);
        this.rdEscapeToNCRHexaU.setText("Uppercase hexadecimal numeric character reference (\u00e1 --> &&#xE1;)");
        this.rdEscapeToNCRHexaL = new Button((Composite)group, 16);
        this.rdEscapeToNCRHexaL.setText("Lowercase hexadecimal numeric character reference (\u00e1 --> &&#xe1;)");
        this.rdEscapeToNCRDeci = new Button((Composite)group, 16);
        this.rdEscapeToNCRDeci.setText("Decimal numeric character reference (\u00e1 --> &&#224;)");
        this.rdEscapeToCER = new Button((Composite)group, 16);
        this.rdEscapeToCER.setText("Character entity reference (\u00e1 --> &&aacute;)");
        this.rdEscapeToJavaU = new Button((Composite)group, 16);
        this.rdEscapeToJavaU.setText("Uppercase Java-style notation (\u00e1 --> \\u00E1)");
        this.rdEscapeToJavaL = new Button((Composite)group, 16);
        this.rdEscapeToJavaL.setText("Lowrcase Java-style notation (\u00e1 --> \\u00e1)");
        this.formattedOutput = "User-defined notation (\u00e1 --> %s)";
        this.rdEscapeToUserFormat = new Button((Composite)group, 16);
        this.rdEscapeToUserFormat.setLayoutData((Object)new GridData(768));
        this.rdEscapeToUserFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.edUserFormat.setEnabled(ParametersEditor.this.rdEscapeToUserFormat.getSelection());
                ParametersEditor.this.chkUseBytes.setEnabled(ParametersEditor.this.rdEscapeToUserFormat.getSelection());
            }
        });
        this.edUserFormat = new Text((Composite)group, 2048);
        GridData gdTmp = new GridData(768);
        gdTmp.horizontalIndent = 16;
        this.edUserFormat.setLayoutData((Object)gdTmp);
        this.edUserFormat.addModifyListener(e -> this.updateUserOutput());
        this.chkUseBytes = new Button((Composite)group, 32);
        this.chkUseBytes.setText("Use the byte values");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = 16;
        this.chkUseBytes.setLayoutData((Object)gdTmp);
        group = new Group(cmpTmp, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText("Miscellaneous");
        group.setLayoutData((Object)new GridData(768));
        this.chkBOMonUTF8 = new Button((Composite)group, 32);
        this.chkBOMonUTF8.setText("Use Byte-Order-Mark for UTF-8 output");
        this.chkReportUnsupported = new Button((Composite)group, 32);
        this.chkReportUnsupported.setText("List characters not supported by the output encoding");
    }

    private void updateUserOutput() {
        String tmp = this.edUserFormat.getText();
        if (tmp.length() == 0) {
            tmp = "?";
        } else {
            try {
                tmp = String.format(tmp, 225);
            }
            catch (Exception e) {
                tmp = "<!ERROR!>";
            }
        }
        this.rdEscapeToUserFormat.setText(String.format(this.formattedOutput, tmp));
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.chkUnescapeNCR.setSelection(this.params.getUnescapeNCR());
        this.chkUnescapeCER.setSelection(this.params.getUnescapeCER());
        this.chkUnescapeJava.setSelection(this.params.getUnescapeJava());
        switch (this.params.getEscapeNotation()) {
            case 2: {
                this.rdEscapeToNCRDeci.setSelection(true);
                break;
            }
            case 3: {
                this.rdEscapeToCER.setSelection(true);
                break;
            }
            case 4: {
                this.rdEscapeToJavaU.setSelection(true);
                break;
            }
            case 5: {
                this.rdEscapeToJavaL.setSelection(true);
                break;
            }
            case 6: {
                this.rdEscapeToUserFormat.setSelection(true);
                break;
            }
            case 1: {
                this.rdEscapeToNCRHexaL.setSelection(true);
                break;
            }
            default: {
                this.rdEscapeToNCRHexaU.setSelection(true);
            }
        }
        this.edUserFormat.setText(this.params.getUserFormat());
        this.chkUseBytes.setSelection(this.params.getUseBytes());
        this.rdEscapeAll.setSelection(this.params.getEscapeAll());
        this.rdEscapeUnsupported.setSelection(!this.params.getEscapeAll());
        this.chkBOMonUTF8.setSelection(this.params.getBOMonUTF8());
        this.chkReportUnsupported.setSelection(this.params.getReportUnsupported());
        this.updateUserOutput();
        this.edUserFormat.setEnabled(this.rdEscapeToUserFormat.getSelection());
        this.chkUseBytes.setEnabled(this.rdEscapeToUserFormat.getSelection());
    }

    private boolean saveData() {
        this.params.setUnescapeNCR(this.chkUnescapeNCR.getSelection());
        this.params.setUnescapeCER(this.chkUnescapeCER.getSelection());
        this.params.setUnescapeJava(this.chkUnescapeJava.getSelection());
        this.params.setEscapeAll(this.rdEscapeAll.getSelection());
        this.params.setEscapeNotation(this.getEscapeNotation());
        String tmp = this.edUserFormat.getText();
        this.params.setUserFormat(tmp);
        this.params.setUseBytes(this.chkUseBytes.getSelection());
        this.params.setBOMonUTF8(this.chkBOMonUTF8.getSelection());
        this.params.setReportUnsupported(this.chkReportUnsupported.getSelection());
        this.result = true;
        return this.result;
    }

    int getEscapeNotation() {
        if (this.rdEscapeToNCRHexaL.getSelection()) {
            return 1;
        }
        if (this.rdEscapeToCER.getSelection()) {
            return 3;
        }
        if (this.rdEscapeToJavaL.getSelection()) {
            return 5;
        }
        if (this.rdEscapeToJavaU.getSelection()) {
            return 4;
        }
        if (this.rdEscapeToNCRDeci.getSelection()) {
            return 2;
        }
        if (this.rdEscapeToUserFormat.getSelection()) {
            return 6;
        }
        return 0;
    }
}

