/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications;

import net.sf.okapi.applications.IOkapiLoggerAppender;
import org.slf4j.event.Level;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class OkapiLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    private static IOkapiLoggerAppender appender;

    public OkapiLogger(String name) {
        this.name = name;
    }

    public static void setAppender(IOkapiLoggerAppender newAppender) {
        appender = newAppender;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(Level.TRACE);
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.handle_0ArgsCall(Level.TRACE, msg, null);
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.handle_1ArgsCall(Level.TRACE, format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.handle2ArgsCall(Level.TRACE, format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.handleArgArrayCall(Level.TRACE, format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.handle_0ArgsCall(Level.TRACE, msg, t);
        }
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(Level.DEBUG);
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.handle_0ArgsCall(Level.DEBUG, msg, null);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.handle_1ArgsCall(Level.DEBUG, format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.handle2ArgsCall(Level.DEBUG, format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.handleArgArrayCall(Level.DEBUG, format, arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.handle_0ArgsCall(Level.DEBUG, msg, t);
        }
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(Level.INFO);
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.handle_0ArgsCall(Level.INFO, msg, null);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.handle_1ArgsCall(Level.INFO, format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.handle2ArgsCall(Level.INFO, format, arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.handleArgArrayCall(Level.INFO, format, arguments);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.handle_0ArgsCall(Level.INFO, msg, t);
        }
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(Level.WARN);
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.handle_0ArgsCall(Level.WARN, msg, null);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.handle_1ArgsCall(Level.WARN, format, arg);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.handle2ArgsCall(Level.WARN, format, arg1, arg2);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.handleArgArrayCall(Level.WARN, format, arguments);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.handle_0ArgsCall(Level.WARN, msg, t);
        }
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(Level.ERROR);
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.handle_0ArgsCall(Level.ERROR, msg, null);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.handle_1ArgsCall(Level.ERROR, format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.handle2ArgsCall(Level.ERROR, format, arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.handleArgArrayCall(Level.ERROR, format, arguments);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.handle_0ArgsCall(Level.ERROR, msg, t);
        }
    }

    private boolean isLevelEnabled(Level level) {
        if (appender == null) {
            return false;
        }
        if (level == null) {
            return true;
        }
        return level.toInt() >= appender.getLevel().toInt();
    }

    private void handle_0ArgsCall(Level level, String msg, Throwable t) {
        this.handleNormalizedLoggingCall(level, msg, null, t);
    }

    private void handle_1ArgsCall(Level level, String msg, Object arg1) {
        this.handleNormalizedLoggingCall(level, msg, new Object[]{arg1}, null);
    }

    private void handle2ArgsCall(Level level, String msg, Object arg1, Object arg2) {
        if (arg2 instanceof Throwable) {
            this.handleNormalizedLoggingCall(level, msg, new Object[]{arg1}, (Throwable)arg2);
        } else {
            this.handleNormalizedLoggingCall(level, msg, new Object[]{arg1, arg2}, null);
        }
    }

    private void handleArgArrayCall(Level level, String msg, Object[] args) {
        Throwable throwableCandidate = MessageFormatter.getThrowableCandidate((Object[])args);
        if (throwableCandidate != null) {
            Object[] trimmedCopy = MessageFormatter.trimmedCopy((Object[])args);
            this.handleNormalizedLoggingCall(level, msg, trimmedCopy, throwableCandidate);
        } else {
            this.handleNormalizedLoggingCall(level, msg, args, null);
        }
    }

    private void handleNormalizedLoggingCall(Level level, String format, Object[] arguments, Throwable throwable) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        if (ft.getThrowable() != null && throwable != null) {
            throw new IllegalArgumentException("both last element in argument array and last argument are of type Throwable");
        }
        if (ft.getThrowable() != null) {
            throw new IllegalStateException("fix above code");
        }
        appender.log(this.name, level, ft.getMessage(), throwable);
    }
}

