/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.tikal;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import net.sf.okapi.applications.IOkapiLoggerAppender;
import net.sf.okapi.common.UserConfiguration;
import org.slf4j.event.Level;

public class TikalLoggerAppender
implements IOkapiLoggerAppender {
    private static Level level = Level.INFO;
    private static final String consoleEncodingName = TikalLoggerAppender.getConsoleEncodingName();
    private static final PrintStream ps = TikalLoggerAppender.getEncodedPrintStream(consoleEncodingName);

    public void log(String loggerName, Level level, String msg, Throwable throwable) {
        ps.println(msg);
        if (throwable != null && level.toInt() <= Level.TRACE.toInt()) {
            throwable.printStackTrace(ps);
        }
    }

    public Level getLevel() {
        return level;
    }

    public void setLevel(Level newLevel) {
        level = newLevel;
    }

    private static String getConsoleEncodingName() {
        String osName = System.getProperty("os.name");
        String enc = null;
        enc = osName.contains("OS X") ? "UTF-8" : (osName.startsWith("Windows") ? "cp850" : Charset.defaultCharset().name());
        UserConfiguration uc = new UserConfiguration();
        uc.load("Tikal");
        return uc.getProperty("displayEncoding", enc);
    }

    private static PrintStream getEncodedPrintStream(String encoding) {
        try {
            return new PrintStream((OutputStream)System.out, true, encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace(System.out);
            return System.out;
        }
    }

    public String getEncodingName() {
        return consoleEncodingName;
    }
}

